package com.huigou.topsun.customer.application.Impl;

import com.huigou.data.jdbc.util.BatchSqlUpdateDetail;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.topsun.base.dictionary.domain.DictionaryImportData;
import com.huigou.topsun.customer.application.MSMDictionaryImportApplication;
import com.huigou.topsun.customer.domain.MonthlySettlementMethodData;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.uasp.tool.dataimport.application.ExcelImportInterface;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * title:
 * author:ZHT
 * date:2023/12/20
 * description:
 */
@Service("MSMDictionaryImportApplication")
public class MSMDictionaryImportApplicationImpl extends BaseApplication implements MSMDictionaryImportApplication, ExcelImportInterface {

    @Override
    public void executeImport(String batchNumber) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "queryTempData");

        //前提是建立数据字典，不添加明细。这里传入数据字典的编码
//        String dictionaryId = sqlExecutorDao.queryToString(queryDescriptor.getSql(), "monthlySettlementMethod");

        String sql = queryDescriptor.getSqlByName("queryImpTempDatas");
        //获取导入的数据条目
        List<MonthlySettlementMethodData> tmpDatas = this.sqlExecutorDao.queryToList(sql, MonthlySettlementMethodData.class, batchNumber);
        if (tmpDatas == null || tmpDatas.size() == 0) {
            return;
        }
        // 插入预算记录
        BatchSqlUpdateDetail inserts = this.getBatchInsertDetail();
        for (MonthlySettlementMethodData tmp : tmpDatas) {
//            tmp.setDictionaryId(dictionaryId);
            if (!tmp.isError()) {
                // 执行插入
                tmp.setId(tmp.getTmpId());
                tmp.setStatus("1");
                inserts.setRows(tmp);
            }
        }
        inserts.flush();
    }

    private BatchSqlUpdateDetail getBatchInsertDetail() {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "queryTempData");
        Map<String, Integer> paramType = new HashMap<String, Integer>();
        return BatchSqlUpdateDetail.newInstance(this.sqlExecutorDao.getDataSource(),
                queryDescriptor.getSqlByName("insertRecord"), paramType);
    }
}
