package com.huigou.topsun.customer.application.Impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.topsun.customer.application.CustomerBaseInfoApplication;
import com.huigou.topsun.customer.domain.*;
import com.huigou.topsun.customer.domain.vo.CustomerVo;
import com.huigou.topsun.customer.repository.*;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class CustomerBaseInfoApplicationImpl extends BaseApplication implements CustomerBaseInfoApplication {

    public static final String QUERY_XML_FILE_PATH = "config/topsun/customer/customerMapper.xml";
    @Autowired
    private ProvinceRepository provinceRepository;
    @Autowired
    private CustomerRepository customerRepository;
    @Autowired
    private CustomerBankRepository customerBankRepository;
    @Autowired
    private CustomerContactRepository customerContactRepository;
    @Autowired
    private CustomerOrderRepository customerOrderRepository;


    @Override
    public Map<String, String> findByProvinceCode(String provinceCode) {
        Province province = provinceRepository.findByProvinceCode(provinceCode);
        Map<String, String> provinceMap = new HashMap<>();

        if (province != null) {
            String provinceParentId = province.getProvinceParentId();
            //获取上一级信息
            Province parentProvince = provinceRepository.findByProvinceCode(provinceParentId);
            if (parentProvince != null && !provinceParentId.equals(0)) {
                //获取上一级信息
                Province grandParentProvince = provinceRepository.findByProvinceCode(parentProvince.getProvinceParentId());
                if (grandParentProvince != null) {
                    //传入的是三级id
                    provinceMap.put("primaryProvinceCode", grandParentProvince.getProvinceCode());
                    provinceMap.put("grandParentProvince", grandParentProvince.getProvinceName());
                    provinceMap.put("secondProvinceCode",parentProvince.getProvinceCode());
                    provinceMap.put("parentProvince", parentProvince.getProvinceName());
                    provinceMap.put("province", province.getProvinceName());
                } else {
                    //传入的是二级id
                    provinceMap.put("primaryProvinceCode", parentProvince.getProvinceCode());
                    provinceMap.put("grandParentProvince", parentProvince.getProvinceName());
                    provinceMap.put("secondProvinceCode",province.getProvinceCode());
                    provinceMap.put("parentProvince", province.getProvinceName());
                }
            }
        }

        return provinceMap;
    }

    @Override
    public CustomerVo findCustomerByCustomerId(String customerId) {


        Customer customer = customerRepository.findCustomerByCustomerId(customerId);
        String provinceCode = customer.getProvinceCode();
        Map<String, String> provinceMap = findByProvinceCode(provinceCode);
        CustomerVo customerVo = new CustomerVo();

        if (provinceMap.containsKey("grandParentProvince")) {
            String province = provinceMap.get("grandParentProvince");
            customerVo.setProvince(province);
        }
        if (provinceMap.containsKey("parentProvince")) {
            String city = provinceMap.get("parentProvince");
            customerVo.setCity(city);
        }
        if (provinceMap.containsKey("province")) {
            String county = provinceMap.get("province");
            customerVo.setCounty(county);
        }
        if (provinceMap.containsKey("primaryProvinceCode")) {
            String primaryProvinceCode = provinceMap.get("primaryProvinceCode");
            customerVo.setPrimaryProvinceCode(primaryProvinceCode);
        }
        if (provinceMap.containsKey("secondProvinceCode")) {
            String secondProvinceCode = provinceMap.get("secondProvinceCode");
            customerVo.setSecondProvinceCode(secondProvinceCode);
        }


//        for (Province province : provinceList) {
//            provinceInfoList.append(province.getProvinceName());
//        }
//        String provinceInfo = provinceInfoList.toString();
        BeanUtils.copyProperties(customer, customerVo);

        return customerVo;
    }

    @Override
    public CustomerBank findCustomerBankByCustomerId(String customerId) {
        CustomerBank customerBank = customerBankRepository.findCustomerBankByCustomerId(customerId);
        return customerBank;
    }

    @Override
    public List<CustomerContact> findCustomerContactByCustomerId(String customerId) {
        List<CustomerContact> customerContactList = customerContactRepository.findCustomerContactByCustomerId(customerId);
        return customerContactList;

    }

    @Override
    public void deleteByCustomerId(String customerId) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "deleteCustomerBank");
        this.sqlExecutorDao.executeUpdate(queryDescriptor.getSql(), customerId);
    }

    @Override
    public CustomerOrder findCustomerOrderByCustomerId(String customerId) {
        CustomerOrder customerOrder = customerOrderRepository.findCustomerOrderByCustomerId(customerId);
        return customerOrder;
    }


}
