package com.huigou.topsun.customer.application;

import com.huigou.topsun.customer.domain.*;
import com.huigou.topsun.customer.domain.query.CustomerQueryRequest;
import com.huigou.topsun.customer.domain.vo.CustomerListVo;
import com.huigou.topsun.customer.domain.vo.CustomerVo;
import com.huigou.topsun.customer.domain.vo.ReturnCustomerListVo;

import java.util.List;
import java.util.Map;

/**
 * 分页查询客户信息数据
 */
public interface CustomerApplication {
    Map<String, Object> findCustomerByPage(CustomerQueryRequest customerQueryRequest);

    List<CustomerContact> findContactByPage(String customerId);
    void deleteContactById(String id);

    void deleteContactByIds(List<String> ids);

    CustomerVo saveCustomer(CustomerVo customerVo, List<CustomerContact> customerContactList, List<CustomerDebtContact> baoshenEmailList, List<CustomerDebtContact> customerEmailList, List<CustomerRelated> customerRelatedList, List<CustomerPayInfo> customerPayInfoList);

    void deleteCustomerAndAffiliatedInfoByCustomerId(List<String> customerIds);


    List<CustomerListVo> getCustomerList();

    List<ReturnCustomerListVo> getReturnCustomerListVoList(List<CustomerListVo> customerListVoList);
}
