package com.huigou.topsun.base.dictionary.application.impl;

import cn.hutool.core.util.NumberUtil;
import com.huigou.data.jdbc.util.BatchSqlUpdateDetail;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.topsun.base.dictionary.GlobalCode;
import com.huigou.topsun.base.dictionary.application.DictionaryImportApplication;
import com.huigou.topsun.base.dictionary.domain.DictionaryImportData;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.uasp.bmp.configuration.application.DictionaryApplication;
import com.huigou.uasp.bmp.configuration.domain.model.SysDictionary;
import com.huigou.uasp.bmp.configuration.repository.SysDictionaryRepository;
import com.huigou.uasp.tool.dataimport.application.ExcelImportInterface;
import com.huigou.util.StringUtil;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.sql.Types;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2023/12/20/10:31
 * @Description:
 */
@Service("dictionaryImportApplication")
public class DictionaryImportApplicationImpl extends BaseApplication implements DictionaryImportApplication,ExcelImportInterface {

    @Override
    public void executeImport(String batchNumber) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "queryTempData");

        //前提是建立数据字典，不添加明细。这里传入数据字典的编码
        String dictionaryId = sqlExecutorDao.queryToString(queryDescriptor.getSql(), GlobalCode.get());

        String sql = queryDescriptor.getSqlByName("queryImpTempDatas");
        //获取导入的数据条目
        List<DictionaryImportData> tmpDatas = this.sqlExecutorDao.queryToList(sql, DictionaryImportData.class, batchNumber);
        if (tmpDatas == null || tmpDatas.size() == 0) {
            return;
        }
        // 插入预算记录
        BatchSqlUpdateDetail inserts = this.getBatchInsertDetail();
        for (DictionaryImportData tmp : tmpDatas) {
            tmp.setDictionaryId(dictionaryId);
            if (!tmp.isError()) {
                // 执行插入
                tmp.setId(tmp.getTmpId());
                tmp.setStatus("1");
                inserts.setRows(tmp);
            }
        }
        inserts.flush();
    }

    private BatchSqlUpdateDetail getBatchInsertDetail() {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "queryTempData");
        Map<String, Integer> paramType = new HashMap<String, Integer>();
        return BatchSqlUpdateDetail.newInstance(this.sqlExecutorDao.getDataSource(),
                queryDescriptor.getSqlByName("insertRecord"), paramType);
    }
}
