var resourceGridManager = null ,processMaterialGridManager=null;

$(document).ready(function() {
	initializateUI();
	loadResourceGrid();
	loadProcessMaterialGrid();
	bindEvent();
});


function initializateUI() {
	UICtrl.layout("#layout", {leftWidth: 3});  
}

function loadResourceGrid() {
	var toolbarOptions = UICtrl.getDefaultToolbarOptions({
		addHandler: function(){
			UICtrl.addGridRow(resourceGridManager);
		},
		deleteHandler: function (){
			var _grid = UICtrl.getGridManager('#resourceGrid');
			DataUtil.delSelectedRows({
				action: 'process/deleteProcessResource.ajax',
				param: {},
				gridManager: _grid,
				idFieldName: 'processResourceId',
				onSuccess: function () {
					reloadResourceGrid();
				}
			});
		},
	});
	resourceGridManager =  UICtrl.grid("#resourceGrid", {
        columns: [
                  { display: "topsun.process.resource.name", name: "resourceName", width: 200, minWidth: 60, type: "string", align: "left",
					  editor: {
						  required: true, type: "select",
						  data: {
							  type: 'system',
							  name: "resourceNameGroup",
							  back: {
								  id: "resourceId",
								  gxmc:"resourceName",
								  version:"version",
							  },
							  getParam: function () {
								  return {paramValue: $("#processType").val()}
							  },
						  },
					  }
				  },
                  { display: "topsun.process.resource.version", name: "version", width: 200, minWidth: 60, type: "string", align: "left" },
                  ],
        dataAction: "server",
     	url: web_app.name + '/process/slicedProcessResourceList.ajax',
		parms:{processId:$("#processId").val()},
     	pageSize: 20,
     	usePager: true,
     	toolbar: toolbarOptions,
		enabledEdit: true,
     	width: "100%",
     	height: "300",
     	heightDiff: -8,
     	checkbox: true,
     	fixedCellHeight: true,
     	selectRowButtonOnly: true,
     	onDblClickRow : function(data, rowindex, rowobj) {
			//updateHandler(data);
		}
    });
    UICtrl.setSearchAreaToggle(resourceGridManager);
}

function reloadResourceGrid() {
	resourceGridManager.loadData();
}

function loadProcessMaterialGrid() {
	var toolbarOptions = UICtrl.getDefaultToolbarOptions({
		addHandler: function(){
			UICtrl.addGridRow(processMaterialGridManager);
		},
		deleteHandler: function (){
			var _grid = UICtrl.getGridManager('#processMaterialGrid');
			DataUtil.delSelectedRows({
				action: 'process/deleteProcessMaterialItem.ajax',
				param: {},
				gridManager: _grid,
				idFieldName: 'processMaterialItemId',
				onSuccess: function () {
					reloadProcessMaterialGrid();
				}
			});
		},
	});
	processMaterialGridManager =  UICtrl.grid("#processMaterialGrid", {
		columns: [
			{ display: "topsun.process.material.name", name: "materialName", width: 200, minWidth: 60, type: "string", align: "left",
				editor: {
					required: true, type: "select",
					data: {
						type: 'system',
						name: "sapMaterialSelect",
						back: {
							materialId: "materialId",
							materialName:"materialName",
							materialUnit:"materialUnit",
							materialJson:"materialJson",
						}
					},
				}
			},
			{ display: "topsun.process.material.unit", name: "materialUnit", width: 100, minWidth: 60, type: "string", align: "left" },
			{ display: "topsun.process.material.number", name: "materialNumber", width: 100, minWidth: 60, type: "string", align: "left" ,
				editor: {
					type: 'text',
					mask: 'positiveMoney',
					required: true
				}
			},
			{ display: "topsun.process.material.content", name: "materialJson", width: 400, minWidth: 60, type: "string", align: "left" },
		],
		dataAction: "server",
		url: web_app.name + '/process/slicedProcessMaterialItems.ajax',
		parms:{processId:$("#processId").val()},
		pageSize: 20,
		usePager: true,
		toolbar: toolbarOptions,
		enabledEdit: true,
		width: "100%",
		height: "300",
		heightDiff: -8,
		checkbox: true,
		fixedCellHeight: true,
		selectRowButtonOnly: true,
		onDblClickRow : function(data, rowindex, rowobj) {
			//updateHandler(data);
		}
	});
	UICtrl.setSearchAreaToggle(processMaterialGridManager);
}
function reloadProcessMaterialGrid() {
	processMaterialGridManager.loadData();
}

function bindEvent() {
	$("#save").click(function () {
		saveData("save");
	})
	$("#submit").click(function () {
		saveData("submit");
	})

	$("#close").click(function () {//关闭
		closeDispatchTabItem();
	})
}

function getProcessDetail(processAction) {
	//采购订单保存时数据不进行必填验证，提交时数据才进行必填验证
	var op = {};
	var check = true;
	var resourceList = [];
	var processMaterialList = [];
	if (processAction == "save") {
		check = false;
	}
	op = {check: check};
	var process = $('#submitForm').formToJSON(op);
	if (!process) {
		return false;
	}
	resourceList = DataUtil.getGridData({gridManager: resourceGridManager, isAllData: true, onCheck: check})
	if (!resourceList) {
		return false;
	}
	process.resourceList = $.toJSON(resourceList);

	processMaterialList = DataUtil.getGridData({gridManager: processMaterialGridManager, isAllData: true, onCheck: check})
	if (!processMaterialList) {
		return false;
	}
	process.processMaterialList = $.toJSON(processMaterialList);
	return process;
}

function saveData(action) {
	var processDetail = getProcessDetail("submit");
	if (!processDetail) {
		return;
	}
	Public.ajax(web_app.name + '/process/saveProcess.ajax?code=' + action,processDetail,
		function (data) {
			setId(data.processId);
			Public.successTip("common.tip.success");
			processGridManager.setParm('processId', data.processId);
			processGridManager.loadData();
		}
	);
}

function closeDispatchTabItem() {
	UICtrl.closeCurrentTab();
}


