var gridManager = null;

$(document).ready(function () {
    debugger
    initializateUI()
    loadNonProdApplyListGrid();
})
function initializateUI() {
    UICtrl.layout("#layout", {leftWidth: 3});
}
function loadNonProdApplyListGrid() {

    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function (){
            addHandler()
        },
        deleteHandler: deleteHandler,
    });
    gridManager = UICtrl.grid("#nonProdApplyListGrid", {
        columns: [
            {display: "申请单编号", name: "billCode", width: 60, minWidth: 60, type: "string", align: "left"},
            {display: "申请人", name: "personMemberName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "申请部门", name: "deptName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "申请日期", name: "fillinDate", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "维护类型", name: "maintenanceType", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "批准人", name: "approver", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "批准日期", name: "approvalDate", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "通用品名", name: "genericName", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "适用标准", name: "applicableStandard", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "基本计量单位", name: "baseUnit", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "规格", name: "specifications", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "材质", name: "material", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "版式", name: "layout", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "尺码", name: "size", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "品牌", name: "brand", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "用途", name: "materialUsage", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "物品属性", name: "itemAttributes", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "业务用途", name: "business_usage", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "文本说明", name: "textDescription", width: 140, minWidth: 60, type: "string", align: "left"},

        ],
        dataAction: "server",
        url: web_app.name + '/sapNonProdApply/slicedNonProdApplyList.ajax',
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            doView(data.id);
        }
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}
function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}


//重写DataUtil的getUpdateRowId函数、它默认取行的id列
DataUtil.getUpdateRowId = function (gridManager) {
    var result = DataUtil.getUpdateRow(gridManager);
    if (result) {
        return result.proofingMakeId;
    }
    return result;
}

//删除按钮
function deleteHandler() {
    DataUtil.del({
        action: 'sapNonProdApply/deleteNonProdApply.ajax',
        gridManager: gridManager, idFieldName: 'id',
        onSuccess: function () {
            reloadGrid();
        }
    });
}

function addHandler() {
    UICtrl.addTabItem({
        tabid: 'nonProdApply',
        text: "统计指标数据",
        url: web_app.name + '/sapNonProdApply/forwardNonProdApplyDetail.job'
    });
}

function doView(id) {
    UICtrl.addTabItem({
        tabid: 'showNonProdApply'+id,
        text: "统计指标详情",
        url: web_app.name + '/sapNonProdApply/showNonProdApply.job?bizId='+id+"&isDetailPage=true"
    });
}