var bomGridManager = null, technologyGridManager = null;

$(document).ready(function () {
    initializateUI();
    initializateBomGrid();
    //initializateTechnologyGrid();
});


function initializateUI() {
    UICtrl.layout("#layout", {leftWidth: 3});
    appendTaskinstRelations(null);
}

function initializateBomGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function(){
            UICtrl.addGridRow(bomGridManager,{ sequence: bomGridManager.getData().length + 1 });
        },
        deleteHandler: function (){
            var _grid = UICtrl.getGridManager('#bomGrid');
            DataUtil.delSelectedRows({
                action: 'quotationItem/deleteQuotationItem.ajax',
                param: {},
                gridManager: _grid,
                idFieldName: 'quotationItemId',
                onSuccess: function () {
                    reloadGrid();
                }
            });
        },
    });
    bomGridManager = UICtrl.grid("#bomGrid", {
        columns: [
            {display: "序号", name: "sequence", width: 80, minWidth: 60, type: "string", align: "left",
                editor: { type: 'spinner', min: 1, max: 100, mask: 'nnn'}
            },
            {
                display: "名称", name: "productName", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {
                    data: {
                        type: 'system',
                        name: "productChoose",
                        back: {
                            productId: "productId",
                            //productCode: "productCode",
                            productName: "productName",
                            //productUnit: "productUnit",
                        }
                    },
                    required: false,
                    type: "select"
                }
            },
            {display: "产品代号", name: "productCodeName", width: 120, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: false,
                    type: 'text'
                }
            },
            {display: "图片", name: "picture", width: 120, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: false,
                    type: 'text'
                }
            },
            {
                display: "产品参数", name: "productParameter", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: false,
                    type: 'text'
                }
            },
            {
                display: "含13%增值税&含运费单价（RMB/张）", name: "taxPrice", width: 250, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: false,
                    type: 'text',
                    mask: '9999999.99'
                }
            },
            {
                display: "出厂价单价（USD/张）", name: "price", width: 200, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: false,
                    type: 'text',
                    mask: '9999999.99'
                }
            },
            {
                display: "MOQ(最小起订量)", name: "moq", width: 120, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: false,
                    type: 'text',
                    mask: '9999999.99'
                }
            },
            {
                display: "备注", name: "remark", width: 200, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: false,
                    type: 'text'
                }
            },
        ],
        dataAction: "server",
        url: web_app.name + '/quotationItem/queryQuotationItemList.ajax',
        parms: {quotationId: getId()},
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        enabledEdit: true,
        width: "100%",
        height: "90%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            updateHandler(data.proofingMakeId);
        },
        onAfterShowData: function (currentData) {
            setTimeout(function () {
                //加载工艺
                //reloadTechnologyGrid();
        },200)
        },
        onAfterEdit:function (item) {
            //加载工艺
            if (item.column.name == "productCode") {
                //reloadTechnologyGrid();
            }
        }
    });
    UICtrl.setSearchAreaToggle(bomGridManager);
}

function initializateTechnologyGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({});
    technologyGridManager = UICtrl.grid("#technologyGrid", {
        columns: [
            //{display: "工艺", name: "technologyName", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "工序", name: "processName", width: 120, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: false,
                    type: 'text'
                }
            },
            {display: "资源", name: "resourceName", width: 120, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: false,
                    type: 'text'
                }
            },
        ],
        dataAction: "server",
        url: web_app.name + '/technology/queryTechnologyByProduct.ajax',
        //parms: {productId: getId()},
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "400",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            updateHandler(data.proofingMakeId);
        }
    });
    UICtrl.setSearchAreaToggle(technologyGridManager);
}

function reloadGrid() {
    bomGridManager.loadData();
}

function reloadTechnologyGrid(){
    var datas = bomGridManager.rows;
    var productIdList=[];
    if (datas.length >0){
        datas.forEach(data=>{
            var productId = data.productId;
            if (productId != null && productId !== ""){
                productIdList.push(productId);
            }
        })
        if (productIdList.length > 0){
            var param = {ids:$.toJSON(productIdList)};
            $('#technologyGrid').ligerGetGridManager().options.url =web_app.name + '/technology/queryTechnologyByProduct.ajax';
            _grid = UICtrl.getGridManager('#technologyGrid');
            UICtrl.gridSearch(_grid, param);
        }
    }
}

//获取数据保存的参数
function getExtendedData(processAction) {
    //回退、打回、转交时，不需要验证必填项是否已经填写；
    if (processAction == ProcessAction.BACK
        || processAction == ProcessAction.REPLENISH
        || processAction == ProcessAction.TRANSMIT) {
        //不验证
        $('#submitForm').attr('check', false);
    }
    const isAllData = $('#oldId') || !getId();
    var extendedData = {};
    var _grid = UICtrl.getGridManager('#bomGrid');
    if (_grid) {
        var datas = DataUtil.getGridData({
            gridManager: _grid,
            isAllData: isAllData
        });
        if (!datas) {
            return false;
        }
        extendedData.quotationItems = Public.encodeJSONURI(datas);
    }
    return extendedData;
}

function getId() {
    return $("#quotationId").val() || "";
}

function setId(value) {
    $("#quotationId").val(value);
    var _grid=UICtrl.getGridManager('#bomGrid');
    _grid.options.parms.quotationId = value;
}





