var gridManager = null;



$(document).ready(function () {
    initializateUI();
    loadSizeGroupListGrid();
});

function initializateUI(){
    UICtrl.layout("#layout", {leftWidth: 3});
}

function loadSizeGroupListGrid() {

    // 获取默认工具选项
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function () {
            addHandler();
        },
        updateHandler: function () {
            updateHandler();
        },
        deleteHandler: deleteHandler,
    });
    gridManager = UICtrl.grid("#sizeGroupListGrid", {
        columns: [
            {display: "尺码组编码", name: "sizeGroupCode", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "尺码组名称", name: "sizeGroupName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "SIZR类型", name: "sizeGroupTypeTextView", width: 120, minWidth: 60, type: "string", align: "left"},
            {
                display: "创建人",
                name: "createdByName",
                width: 100,
                minWidth: 60,
                type: "string",
                align: "left"
            },
            {display: "创建时间", name: "sizeGroupName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "修改人", name: "sizeGroupName", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "修改时间", name: "sizeGroupName", width: 120, minWidth: 60, type: "string", align: "left"},
        ],
        dataAction: "server",
        url: web_app.name + '/sizeGroup/findSizeGroupList.ajax',
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            updateHandler(data);
        }
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}

function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}

function addHandler() {
    UICtrl.addTabItem({
        tabid: 'sizeGroupDetail',
        text: "新增尺码组",
        url: web_app.name + '/sizeGroup/addSizeGroupDetail.do'
    })
}

function updateHandler(row) {
    if (!row) {
        row = DataUtil.getUpdateRow(gridManager);
        if (!row) {
            return;
        }
    }
    UICtrl.addTabItem({
        tabid: 'sizeGroupDetail',
        text: "修改尺码组",
        url: web_app.name + '/sizeGroup/showSizeGroupDetail.do?sizeGroupId='+row.sizeGroupId
    })
}

//删除按钮
function deleteHandler() {
    DataUtil.del({
        action: 'sizeGroup/deleteSizeGroupById.ajax',
        gridManager: gridManager, idFieldName: 'sizeGroupId',
        onSuccess: function () {
            reloadGrid();
        }
    });
}

function getProcessList() {
    var processList = null;
    var processManager = UICtrl.getGridManager('#sizeGroupItemListGrid');
    if (processManager) {
        processList = DataUtil.getGridData({
            gridManager: processManager,
            isAllData: true
        });
        processList = Public.encodeJSONURI(processList);
    }
    return processList;
}