var gridManager = null;

$(document).ready(function () {
    initializateUI();
    loadCostCenterListGrid();
});


function initializateUI() {
    UICtrl.layout("#layout", {leftWidth: 3});
}

function loadCostCenterListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function () {
            addHandler();
        },
        updateHandler: function () {
            updateHandler();
        },
        deleteHandler: deleteHandler,
        // Excel导入按钮
        excelImpManager: {
            id: 'excelImpManager', text: '导入Excel', click: function () {
                excelImpManager();
            }, img: 'fa-link'
        },
    });
    gridManager = UICtrl.grid("#monthlySettlementMethodListGrid", {
        columns: [
            {display: "月结方式编码", name: "methodId", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "月结方式名", name: "method", width: 140, minWidth: 60, type: "string", align: "left"},
            { display: "状态", name: "status", width: 60, minWidth: 60, type: "string", align: "center",
                render: function (item) {
                    return UICtrl.getStatusInfo(item);
                }
            },
        ],
        dataAction: "server",
        url: web_app.name + '/monthlySettlementMethod/slicedMonthlySettlementMethodList.ajax',
        parms: {methodId: getId},
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        // 双击执行
        onDblClickRow: function (data, rowindex, rowobj) {
            updateHandler(data);
        }
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}

function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}

function setId(value) {
    $('#methodId').val(value);
}

function getId() {
    return $("#methodId").val();
}

function addHandler() {
    UICtrl.addTabItem({
        tabid: 'monthlySettlementMethodDetail',
        text: "新增月结方式",
        url: web_app.name + '/monthlySettlementMethod/addMonthlySettlementMethodDetail.do'
    })
}

function updateHandler(row) {
    if (!row) {
        row = DataUtil.getUpdateRow(gridManager);
        if (!row) {
            return;
        }
    }
    UICtrl.addTabItem({
        tabid: 'monthlySettlementMethodDetail',
        text: "修改月结方式",
        url: web_app.name + '/monthlySettlementMethod/showMonthlySettlementMethodDetail.do?methodId=' + row.methodId
    })
}

//删除按钮
function deleteHandler() {
    DataUtil.del({
        action: 'monthlySettlementMethod/deleteMonthlySettlementMethodById.ajax',
        gridManager: gridManager, idFieldName: 'methodId',
        onSuccess: function () {
            reloadGrid();
        }
    });


}

// 导入按钮
function excelImpManager() {
    ExcelImpManager.showImpDialog('月结方式导入', 'monthlySettlementMethod', '100', function () {
        reloadGrid();
    });
}
