package com.huigou.topsun.customer.application.Impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.customer.application.CustomerPayInfoApplication;
import com.huigou.topsun.customer.domain.CustomerDebtContact;
import com.huigou.topsun.customer.domain.CustomerPayInfo;
import com.huigou.topsun.customer.domain.query.CustomerPayInfoQueryRequest;
import com.huigou.topsun.customer.domain.vo.CustomerPayInfoVo;
import com.huigou.topsun.customer.repository.CustomerPayInfoRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * title:
 * author:ZHT
 * date:2023/12/19
 * description:
 */
@Service
public class CustomerPayInfoApplicationImpl extends BaseApplication implements CustomerPayInfoApplication {

    @Autowired
    private CustomerPayInfoRepository customerPayInfoRepository;

    @Override
    public List<CustomerPayInfo> getCustomerPayInfoList(String customerId) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "CustomerPayInfo");
        List<CustomerPayInfo> customerPayInfoList = this.sqlExecutorDao.queryToList(queryDescriptor.getSql(), CustomerPayInfo.class, customerId);
        return customerPayInfoList;
    }

    @Override
    public CustomerPayInfoVo updateCustomerPayInfo(CustomerPayInfo customerPayInfo) {
        // 获取时间
        long timeMillis = System.currentTimeMillis();
        customerPayInfo.setLastModifiedDate(new Date(timeMillis));
        customerPayInfo = customerPayInfoRepository.saveAndFlush(customerPayInfo);
        return CustomerPayInfoVo.getCustomerPayInfoVo(customerPayInfo);
    }

    @Override
    public CustomerPayInfoVo saveCustomerPayInfo(CustomerPayInfo customerPayInfo) {

        // 获取时间
        long timeMillis = System.currentTimeMillis();
        customerPayInfo.setCreatedDate(new Date(timeMillis));
        customerPayInfo = customerPayInfoRepository.saveAndFlush(customerPayInfo);
        return CustomerPayInfoVo.getCustomerPayInfoVo(customerPayInfo);
    }

    @Override
    public void deleteCustomerPayInfo(List<String> ids) {
        ids.forEach(id -> customerPayInfoRepository.delete(id));
    }

    @Override
    public CustomerPayInfoVo getCustomerPayInfoById(String customerPayInfoId) {
        CustomerPayInfo one = customerPayInfoRepository.getOne(customerPayInfoId);
        return CustomerPayInfoVo.getCustomerPayInfoVo(one);
    }

    @Override
    public void deleteByCustomerId(String customerId) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "deleteCustomerPayInfo");
        this.sqlExecutorDao.executeUpdate(queryDescriptor.getSql(), customerId);
    }

}
