package com.huigou.topsun.common;

import com.huigou.context.MessageSourceContext;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * @author xin.lu
 * @Description: TODO
 * @date 2021/5/2311:58
 */
public enum MaterialCheck {
    ORIGINAL(1,"材料原厂检测","材料原厂检测"),
    PROVIDER(2,"承制方来料检验","承制方来料检验");
    private int id;
    private String name;
    private String i18n;

    MaterialCheck(int id, String name,String i18n) {
        this.id = id;
        this.name = name;
        this.i18n = i18n;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getI18n() {
        return i18n;
    }

    public void setI18n(String i18n) {
        this.i18n = i18n;
    }

    public static Map<String, String> getMap() {
        Map<String, String> map = new LinkedHashMap<String, String>(MaterialCheck.values().length);
        for (MaterialCheck c : MaterialCheck.values()) {
            map.put(String.valueOf(c.getId()), MessageSourceContext.getMessage(c.getI18n()));
        }
        return map;
    }

    public static Map<String, String> getZhMap() {
        Map<String, String> map = new LinkedHashMap<String, String>(MaterialCheck.values().length);
        for (MaterialCheck c : MaterialCheck.values()) {
            map.put(String.valueOf(c.getId()), c.getName());
        }
        return map;
    }

    public static MaterialCheck fromId(int id) {
        for (MaterialCheck c : MaterialCheck.values()) {
            if (c.getId() == id) {
                return c;
            }
        }
        return null;
    }

    public static Map<String, String> getValidMap() {
        Map<String, String> map = new LinkedHashMap<String, String>(MaterialCheck.values().length);
        for (MaterialCheck c : MaterialCheck.values()) {
            String statusId = String.valueOf(c.getId());
            map.put(statusId, c.getName());
        }
        return map;
    }
}
