var gridManager = null;

$(document).ready(function () {

    initializateUI();
    loadStatsIndicatorsListGridGrid();
})
function initializateUI() {
    UICtrl.layout("#layout", {leftWidth: 3});
}

function loadStatsIndicatorsListGridGrid() {

    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function (){
            addHandler()
        },
        deleteHandler: deleteHandler,
    });
    gridManager = UICtrl.grid("#statsIndicatorsListGrid", {
        columns: [
            {display: "导入sap", name: "btns", width: 60, minWidth: 60, type: "string", align: "left"},
            {display: "成本控制范围", name: "kokrs", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "凭证日期", name: "bldat", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "过账日期", name: "budat", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "凭证文本", name: "bltxt", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "SAP用户名", name: "usnam", width: 140, minWidth: 60, type: "string", align: "left"},

        ],
        dataAction: "server",
        url: web_app.name + '/sapStatsIndicators/slicedStatsIndicatorsList.ajax',
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            doView(data.id);
        },
        onAfterShowData :function (){
           let obj= gridManager.records;
            Object.keys(obj).forEach(function(key) {
               let node=null;
                console.log(obj[key]);
                if(obj[key].status!==3){
                    node="<div>待审批</div>";
                }else if(obj[key].type!=="S"){
                    node=`<button onclick="sendSapData('${obj[key].id}')" class="btn btn-success" type="button">send</button>`;
                } else{
                    node="<div>成功</div>";
                }
                $("tr[id*='"+key+"'] .btns").replaceWith(node);
            });
        }
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}
function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}


//重写DataUtil的getUpdateRowId函数、它默认取行的id列
DataUtil.getUpdateRowId = function (gridManager) {
    var result = DataUtil.getUpdateRow(gridManager);
    if (result) {
        return result.proofingMakeId;
    }
    return result;
}

//删除按钮
function deleteHandler() {
    DataUtil.del({
        action: 'sapStatsIndicators/deleteStatsIndicators.ajax',
        gridManager: gridManager, idFieldName: 'id',
        onSuccess: function () {
            reloadGrid();
        }
    });
}

function addHandler() {
    UICtrl.addTabItem({
        tabid: 'statsIndicators',
        text: "统计指标数据",
        url: web_app.name + '/sapStatsIndicators/forwardStatsIndicators.job'
    });
}

function doView(id) {
    UICtrl.addTabItem({
        tabid: 'showStatsIndicators'+id,
        text: "统计指标详情",
        url: web_app.name + '/sapStatsIndicators/showStatsIndicators.job?bizId='+id+"&isDetailPage=true"
    });
}

function sendSapData(bizId){
    Public.ajax(web_app.name + '/sapStatsIndicators/againSendSapDate.ajax',{bizId:bizId},function (data){
        reloadGrid();
    })
}