package com.huigou.topsun.sap.statsIndicators.controller;



import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.sap.statsIndicators.application.SapStatsIndicatorsApplication;
import com.huigou.topsun.sap.statsIndicators.application.SapStatsIndicatorsDetailApplication;

import com.huigou.topsun.sap.statsIndicators.domain.SapStatsIndicators;
import com.huigou.topsun.sap.statsIndicators.domain.query.SapStatsIndicatorsDetailQueryRequest;
import com.huigou.topsun.sap.statsIndicators.domain.query.SapStatsIndicatorsQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import com.huigou.util.StringUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.List;
import java.util.Map;


@Controller
@ControllerMapping("/sapStatsIndicators")
public class SapStatsIndicatorsController  extends CommonController {

    protected String getPagePath() {
        return "/biz/topsun/sap/statsIndicators/";
    }

    @Autowired
    SapStatsIndicatorsApplication sapStatsIndicatorsApplication;
    @Autowired
    SapStatsIndicatorsDetailApplication sapStatsIndicatorsDetailApplication;

    public String forwardStatsIndicatorsList(){
        return forward("statsIndicatorsList");
    }

    public String forwardStatsIndicators(){
        this.putAttribute("processDefinitionKey", SapStatsIndicatorsApplication.PROCESS_DEFINITION_KEY);
        this.putAttribute("procUnitId", "Apply");//定义流程环节的id
        SapStatsIndicators sapStatsIndicators = new SapStatsIndicators();
        sapStatsIndicators.setStatusId(BizBillStatus.APPLYING.getId());
        Operator operator = getOperator();//获取当前操作员的详情信息
        sapStatsIndicators.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        return forward("statsIndicators",sapStatsIndicators);
    }


    public String slicedStatsIndicatorsList(){
        SDO sdo = this.getSDO();
        SapStatsIndicatorsQueryRequest queryRequest = sdo.toQueryRequest(SapStatsIndicatorsQueryRequest.class);
        Map<String, Object> map = sapStatsIndicatorsApplication.slicedStatsIndicatorsQuery(queryRequest);
        return toResult(map);
    }


    public String slicedStatsIndicatorsDetailList(){
        SDO sdo = this.getSDO();
        SapStatsIndicatorsDetailQueryRequest queryRequest = sdo.toQueryRequest(SapStatsIndicatorsDetailQueryRequest.class);
        if (StringUtil.isBlank(queryRequest.getStatsIndicatorsId())){
            return toResult(null);
        }
        Map<String, Object> map = sapStatsIndicatorsDetailApplication.slicedStatsIndicatorsDetailQuery(queryRequest);
        return toResult(map);
    }

    /**
     * 工作流审核跳转页面
     * @return
     */
    public String showStatsIndicators() {
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        String isDetailPage = sdo.getString("isDetailPage");
        if("true".equals(isDetailPage)) this.putAttribute("isDetailPage","true");
        SapStatsIndicators sapStatsIndicators = sapStatsIndicatorsApplication.loadSapStatsIndicatorsById(id);
        return forward("statsIndicators", sapStatsIndicators);
    }

    public String deleteStatsIndicators(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        sapStatsIndicatorsApplication.deleteStatsIndicatorsByIds(ids);
        return success();
    }
}