package com.huigou.topsun.sap.fixedAssets.domain;

import java.math.BigDecimal;
import javax.persistence.*;

import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

/**
 * SAP固定资产主数据
 * @TableName sap_fixed_assets
 */
@Table(name="sap_fixed_assets")
@Entity
@Data
public class SapFixedAssets extends FlowBillAbstractEntity {
    /**
     * BPM单号

     */
    @Column(name = "zbpmn")
    private String zbpmn;

    /**
     * 创建标识
     * 用于标识数据是新增或修改，1为新增，2为修改。（必填）
     */
    @Column(name = "zflg")
    private Integer zflg;

    /**
     * 主资产号
       ;资产编号内部生成，当创建标识为2，即修改时，主资产号为必输。
     */
    @Column(name = "anln1")
    private String anln1;

    /**
     * 资产分类
     * 当创建标识为1，即创建时，资产分类必输。
     */
    @Column(name = "anlkl")
    private String anlkl;

    /**
     * 公司代码（必填）
     */
    @Column(name = "bukrs")
    private String bukrs;

    /**
     * 文本（必填）
     */
    @Column(name = "txt50")
    private String txt50;

    /**
     * 存货号；存放地点
     */
    @Column(name = "invnr")
    private String invnr;

    /**
     * 数量
     */
    @Column(name = "menge")
    private BigDecimal menge;

    /**
     * 基本计量单位
     */
    @Column(name = "meins")
    private String meins;

    /**
     * 成本中心（必填）
     */
    @Column(name = "kostl")
    private String kostl;

    /**
     * 责任成本中心
     */
    @Column(name = "kostlv")
    private String kostlv;

    private static final long serialVersionUID = 1L;

    @Override
    protected String getCodeRuleId() {
        return "sapFixedAssets";
    }
}