package com.huigou.topsun.resource.vo;

import com.alibaba.fastjson.JSON;
import com.huigou.topsun.resource.domain.ResourceType;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 资源分类
 * @TableName resource_type
 */
//@Schema(description = "资源类型")
@Data
public class ResourceTypeVo implements Serializable {
    /**
     * 资源库类型ID
     */
    //@Schema(description = "资源库类型ID")
    private String resourceTypeId;

    /**
     * 资源库类型表名
     */
    //@Schema(description = "资源库类型表名")
    private String resourceTableName;

    /**
     * 资源库类型表名称
     */
    //@Schema(description = "资源库类型表名称")
    private String resourceTableTitle;

    /**
     * 父类表名
     */
    //@Schema(description = "父类表名")
    private String parentTableName;

    /**
     * 父类显示名
     */
    //@Schema(description = "父类显示名")
    private String parentTableTitle;

    /**
     * 超类名
     */
    //@Schema(description = "超类表名")
    private String superTableName;

    /**
     * 超类显示名
     */
    //@Schema(description = "超类显示名")
    private String superTableTitle;

    List<ResourceFiledVo> resourceFileds;

    /**
     * 子节点
     */
    private List<ResourceTypeVo> childNode;

    public static ResourceTypeVo getResourceTypeVo(ResourceType resourceType){
        return JSON.parseObject(JSON.toJSONString(resourceType),ResourceTypeVo.class);
    }

    public static ResourceType getResourceType(ResourceTypeVo resourceTypeVo){
        return JSON.parseObject(JSON.toJSONString(resourceTypeVo),ResourceType.class);
    }

}