package com.huigou.topsun.customer.domain.vo;

import com.alibaba.fastjson.JSON;
import com.huigou.topsun.customer.domain.Customer;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.util.Date;

@Data
public class CustomerVo implements Serializable {
    /**
     * 客户id
     */
    private String customerId;

    /**
     * 客户编码
     */
    private String customerCode;

    /**
     * 客户全称
     */
    private String customerName;

    /**
     * 客户简称
     */
    private String customerShortName;

    /**
     * 客户工作时间
     */
    private Date customerWorkTime;

    /**
     * 客户英文名称
     */
    private String customerEnName;

    /**
     * 客户英文名称简称
     */
    private String customerEnShortName;

    /**
     * 省份编码
     */
    private String provinceCode;

    /**
     * 省份信息
     */
    private String provinceInfo;

    /**
     * 客户等级
     */
    private String customerLevel;

    /**
     * 工厂代号
     */
    private String customerFactoryCode;

    /**
     * 地址
     */
    private String customerAddress;

    /**
     * 所属集团
     */
    private String customerGroup;

    /**
     * 邮编
     */
    private String customerZipCode;

    /**
     *
     */
    private String customerBankId;

    /**
     * 开户银行
     */
    private String customerBankDeposit;

    /**
     * 银行账号
     */
    private String customerAccountNo;

    /**
     * 户名
     */
    private String customerAccountName;

    /**
     * 公司法人
     */
    private String customerCorporation;

    /**
     * 工商注册号
     */
    private String businessRegistrationNumber;

    /**
     * 国税注册号
     */
    private String nationalTaxRegistrationNumber;

    /**
     * 客户订单信息id
     */
    private String customerOrderId;



    /**
     * 请款要求
     */
    private String paymentRequest;

    /**
     * 扣款百分比
     */
    private Integer deduction;

    /**
     * 是否要求签回货单
     */
    private String signedBack;

    /**
     * 是否用客户系统货单
     */
    private String customerSysOrder;

    /**
     * 报价币别（currency）
     */
    private String quotationCurrency;

    /**
     * 金额小数位数
     */
    private Integer decimalPlaces;

    /**
     * 签回方式（signedStyle）
     */
    private String signedStyle;

    /**
     * 月结方式（monthlySettlementMethod）
     */
    private String monthlySettlementMethod;

    /**
     * 做账难度等级（accountDifficultLevel）
     */
    private String accountDifficultLevel;

    /**
     * 盖章方式（stampMethod）
     */
    private String stampMethod;

    /**
     * 请款联（paymentRequestForm）
     */
    private String paymentRequestForm;

    /**
     * 客户联（customerReceipt）
     */
    private String customerReceipt;

    /**
     * 订单性质（orderKind）
     */
    private String orderKind;

    /**
     * 品牌
     */
    private String customerBrand;

    /**
     * 收货方签字要求
     */
    private String receiverSignatureRequire;

    /**
     * 出货方式（shipMethod）
     */
    private String shipMethod;

    /**
     * 路线（route）
     */
    private String route;

    /**
     * 备注
     */
    private String remark;

    /**
     * 订单要求（orderRequire）
     */
    private String orderRequire;

    /**
     * 验收要求
     */
    private String acceptanceRequire;

    /**
     * 客户系统验收要求
     */
    private String customerSysAcceptanceRequire;

    /**
     * 做账截止日期
     */
    private Integer accountDeadline;

    /**
     * 客户收账单截止日
     */
    private Integer customerCollectionDeadline;

    /**
     * 订单统计异常期限
     */
    private Integer orderAbnormalDeadline;

    /**
     * 送货单统计异常期限
     */
    private Integer shipAbnormalDeadline;

    /**
     * 请款期限
     */
    private Integer paymentDeadline;

    /**
     * 产品检验报告类型（productInspectionReportType）
     */
    private String productInspectionReportType;

    /**
     * 货单打印要求（shipPrintRequire）
     */
    private String shipPrintRequire;

    /**
     * 货单是否打印送货日期
     */
    private String isPrintDeliveryDate;

    /**
     * 是否开发票
     */
    private String needInvoice;

    /**
     * 生产交货方式（productionDeliveryMethod）
     */
    private String productionDeliveryMethod;

    public String getCustomerId() {
        return customerId;
    }

    public static CustomerVo getCustomerVo(CustomerVo customerVo){
        return JSON.parseObject(JSON.toJSONString(customerVo), CustomerVo.class);
    }

    public static Customer getCustomer(Customer customer){
        return JSON.parseObject(JSON.toJSONString(customer),Customer.class);
    }
}
