package com.huigou.topsun.customer.domain;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

/**
 * 关联客户
 * @TableName customer_related
 */
@Table(name="customer_related")
@Data
@Entity
public class CustomerRelated implements Serializable {
    /**
     * 关联客户id
     */
    @Id
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid", strategy = "guid")
    @Column(name = "customer_related_id")
    private String customerRelatedId;

    /**
     * 客户id
     */
    @Column(name = "customer_id")
    private String customerId;

    /**
     * 关联客户编码
     */
    @Column(name = "customer_code_related")
    private String customerCodeRelated;

    /**
     * 关联客户简称
     */
    @Column(name = "customer_short_name_related")
    private String customerShortNameRelated;

    /**
     * 关联客户全称
     */
    @Column(name = "customer_name_related")
    private String customerNameRelated;

    /**
     * 录入人
     */
    @Column(name = "created_by_name")
    private String createdByName;

    /**
     * 录入时间
     */
    @Column(name = "created_date")
    private Date createdDate;

    private static final long serialVersionUID = 1L;
}