package com.huigou.topsun.customer.application.Impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.customer.application.MonthlySettlementMethodApplication;
import com.huigou.topsun.customer.domain.MonthlySettlementMethod;
import com.huigou.topsun.customer.domain.query.MonthlySettlementMethodQueryRequest;
import com.huigou.topsun.customer.domain.vo.MonthlySettlementMethodVo;
import com.huigou.topsun.customer.repository.MonthlySettlementMethodRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * title:
 * author:ZHT
 * date:2023/12/20
 * description:
 */
@Service
public class MonthlySettlementMethodApplicationImpl extends BaseApplication implements MonthlySettlementMethodApplication {
    @Autowired
    private MonthlySettlementMethodRepository monthlySettlementMethodRepository;


    @Override
    public void deleteById(List<String> ids) {
        ids.forEach(id -> monthlySettlementMethodRepository.delete(id));
    }

    @Override
    public MonthlySettlementMethodVo getOneById(String methodId) {
        MonthlySettlementMethod monthlySettlementMethod = monthlySettlementMethodRepository.getOne(methodId);
        return MonthlySettlementMethodVo.getMonthlySettlementMethodVo(monthlySettlementMethod);
    }

    @Override
    public Map<String, Object> getList(MonthlySettlementMethodQueryRequest monthlySettlementMethodQueryRequest) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "monthlySettlementMethod");
        QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, monthlySettlementMethodQueryRequest);
        Map<String, Object> map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        return map;
    }

    @Override
    public MonthlySettlementMethodVo saveAndUpdate(MonthlySettlementMethod monthlySettlementMethod) {
        return MonthlySettlementMethodVo.getMonthlySettlementMethodVo(monthlySettlementMethodRepository.saveAndFlush(monthlySettlementMethod));
    }
}
