package com.huigou.topsun.customer.application.Impl;

import com.huigou.cache.DictUtil;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.customer.application.CustomerDebtContactApplication;
import com.huigou.topsun.customer.domain.CustomerContact;
import com.huigou.topsun.customer.domain.CustomerDebtContact;
import com.huigou.topsun.customer.domain.query.CustomerDebtContactQueryRequest;
import com.huigou.topsun.customer.domain.vo.CustomerDebtContactVo;
import com.huigou.topsun.customer.repository.CustomerDebtContactRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.Map;

@Service
public class CustomerDebtContactApplicationImpl extends BaseApplication implements CustomerDebtContactApplication {
    // 导入催货款通知邮箱Dao层
    @Autowired
    private CustomerDebtContactRepository customerDebtContactRepository;
    public static final String QUERY_XML_FILE_PATH = "config/topsun/customer/customerMapper.xml";


    @Override
    public List<CustomerDebtContact> getCustomerDebtContactList(String customerId,String customerEmailType) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "customerDebtContact");
        List<CustomerDebtContact> customerDebtContactList = this.sqlExecutorDao.queryToList(queryDescriptor.getSql(), CustomerDebtContact.class, customerId,customerEmailType);
        return customerDebtContactList;
    }

    @Override
    public CustomerDebtContactVo saveCustomerDebtContact(CustomerDebtContact customerDebtContact) {
        // 封装创建时间
        long timestamp = System.currentTimeMillis();
        customerDebtContact.setCreatedDate(new Date(timestamp));

        customerDebtContact = customerDebtContactRepository.saveAndFlush(customerDebtContact);
        CustomerDebtContactVo customerDebtContactVo = CustomerDebtContactVo.getCustomerDebtContactVo(customerDebtContact);

        return customerDebtContactVo;
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public void deleteCustomerDebtContact(List<String> ids) {
        ids.forEach(id -> customerDebtContactRepository.delete(id));
    }

    @Override
    public void deleteByCustomerId(String customerId) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "deleteCustomerDebtContact");
        this.sqlExecutorDao.executeUpdate(queryDescriptor.getSql(), customerId);
    }
}
