package com.huigou.topsun.base.coderule.controller;

import com.huigou.topsun.base.coderule.application.CodeRuleApplication;
import com.huigou.topsun.base.coderule.domain.model.CodeRule;
import com.huigou.topsun.base.coderule.domain.model.CodeRuleKind;
import com.huigou.topsun.base.coderule.domain.query.CodeRuleQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.uasp.log.annotation.LogInfo;
import com.huigou.uasp.log.domain.model.LogType;
import com.huigou.uasp.log.domain.model.OperationType;
import com.huigou.util.SDO;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.Map;

/**
 * 采购编号及合同编号编码规则
 * 
 * @ClassName: CodeRuleController
 * @author
 * @date 2018-06-20 15:20
 * @version V1.0
 */
@Controller
@ControllerMapping("codeRule")
public class CodeRuleController extends CommonController {

    @Autowired
    private CodeRuleApplication codeRuleApplication;

    protected String getPagePath() {
        return "/biz/topsun/base/codeRule/";
    }

    @RequiresPermissions("CodeRule:query")
    @LogInfo(logType = LogType.SYS, subType = "", operaionType = OperationType.LIST, description = "跳转到编号规则表")
    public String forwardListCodeRule() {
        this.putAttribute("ruleKindList", CodeRuleKind.getMap());
        return forward("codeRuleList");
    }

    @RequiresPermissions("CodeRule:query")
    @LogInfo(logType = LogType.BIZ, subType = "", operaionType = OperationType.QUERY, description = "分页查询编号规则表")
    public String slicedQueryCodeRule() {
        SDO sdo = this.getSDO();
        CodeRuleQueryRequest queryRequest = sdo.toQueryRequest(CodeRuleQueryRequest.class);
        Map<String, Object> data = codeRuleApplication.slicedQueryCodeRule(queryRequest);
        return toResult(data);
    }

    @RequiresPermissions("CodeRule:update")
    @LogInfo(logType = LogType.BIZ, subType = "", operaionType = OperationType.DETALL, description = "跳转到编辑编号规则表")
    public String showLoadCodeRule() {
        SDO sdo = this.getSDO();
        String id = sdo.getId();
        CodeRule codeRule = codeRuleApplication.loadCodeRule(id);
        return forward("codeRuleDetail", codeRule);
    }

    @RequiresPermissions("CodeRule:update")
    @LogInfo(logType = LogType.BIZ, subType = "", operaionType = OperationType.UPDATE, description = "新增修改编号规则表")
    public String updateCodeRule() {
        SDO sdo = this.getSDO();
        CodeRule codeRule = sdo.toObject(CodeRule.class);
        codeRuleApplication.saveCodeRule(codeRule);
        return success();
    }

    @RequiresPermissions("CodeRule:update")
    @LogInfo(logType = LogType.BIZ, subType = "", operaionType = OperationType.UPDATE, description = "取号测试")
    public String testGetNextCode() {
        SDO sdo = this.getSDO();
        String orgId = sdo.getString("orgId");
        String ruleKind = sdo.getString("ruleKind");
        CodeRuleKind kind = CodeRuleKind.fromId(ruleKind);
        String code = codeRuleApplication.getNextCode(orgId, null, kind);
        return toResult(code);
    }

}
