package com.huigou.topsun.sap.statsIndicators.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.math.BigDecimal;

/**
 * 
 * @TableName sap_stats_indicators
 */
@Table(name="sap_stats_indicators_detail")
@Entity
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class SapStatsIndicatorsDetail {

    /**
     * 详情id
     */
    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )
    @Column(name = "stats_indicators_detail_id")
    @JsonIgnore
    private String statsIndicatorsDetailId;

    /**
     * 主表id
     */
    @JsonIgnore
    @Column(name = "stats_indicators_id")
    private String statsIndicatorsId;


    /**
     * 行号
     */
    @Column(name = "ZLENR")
    private String zlenr;

    /**
     * 成本中心
     */
    @Column(name = "EKOSTL")
    private String ekostl;

    /**
     * 订单
     */
    @Column(name = "EAUFNR")
    private String eaufnr;

    /**
     * 统计指标
     */
    @Column(name = "STAGR")
    private String stagr;

    /**
     * 统计指标数量
     */
    @Column(name = "MBGBTR")
    private BigDecimal mbgbtr;

    /**
     * 行文本
     */
    @Column(name = "SGTXT")
    private String sgtxt;


}