package com.huigou.topsun.quotation.domain.model;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.*;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

/**
 * 报价单明细
 * @TableName quotation_item
 */
@Table(name="quotation_item")
@Data
@Entity
public class QuotationItem implements Serializable {
    /**
     * 
     */
    @Id
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid", strategy = "guid")
    @Column(name = "quotation_item_id")
    private String quotationItemId;

    /**
     * 报价单id
     */
    @Column(name = "quotation_id")
    private String quotationId;

    /**
     * 序号/行项目
     */
    @Column(name = "sequence")
    private Integer sequence;

    /**
     * 产品id
     */
    @Column(name = "product_id")
    private String productId;

    /**
     * 名称
     */
    @Column(name = "product_name")
    private String productName;

    /**
     * 产品代号
     */
    @Column(name = "product_code_name")
    private String productCodeName;

    /**
     * 图片
     */
    @Column(name = "picture")
    private String picture;


    /**
     * 产品参数
     */
    @Column(name = "product_parameter")
    private String productParameter;

    /**
     * 含13%增值税&含运费单价
     */
    @Column(name = "tax_price")
    private BigDecimal taxPrice;

    /**
     * 出厂价单价
     */
    @Column(name = "price")
    private BigDecimal price;

    /**
     * 最小起订量
     */
    @Column(name = "moq")
    private BigDecimal moq;

    /**
     * 币别（码表currency）
     */
    @Column(name = "currency")
    private String currency;

    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;


    private static final long serialVersionUID = 1L;

}