package com.huigou.topsun.product.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.huigou.topsun.common.NumberToStringSerializer;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author YourUserName
 * 产品工艺工序
 */
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
@Entity
@Table(name = "product_process")
public class ProductProcess implements Serializable {

	/**
	 * 产品工艺工序id
	 */
	@Id
	@JsonSerialize(using = NumberToStringSerializer.class)
	@Column(name = "product_process_id", nullable = false)
	private BigDecimal productProcessId;

	/**
	 * 工艺id
	 */
	@JsonSerialize(using = NumberToStringSerializer.class)
	@Column(name = "product_technology_id", nullable = true)
	private BigDecimal productTechnologyId;

	/**
	 * 生成顺序
	 */
	@Column(name = "production_sequence", nullable = true)
	private Integer productionSequence;

	/**
	 * 工序名称
	 */
	@Column(name = "process_name", nullable = true, length = 32)
	private String processName;

	/**
	 * 是否排期工序
	 */
	@Column(name = "is_schedule_process", nullable = true, length = 10)
	private String isScheduleProcess;

	/**
	 * 是否完成工序
	 */
	@Column(name = "is_finished_process", nullable = true, length = 10)
	private String isFinishedProcess;

	/**
	 * 工艺备注
	 */
	@Column(name = "process_remark", nullable = true, length = 255)
	private String processRemark;

	/**
	 * 完成时间
	 */
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@Column(name = "finished_time", nullable = true)
	private java.util.Date finishedTime;

	/**
	 * 签字
	 */
	@Column(name = "signed", nullable = true, length = 255)
	private String signed;
	
	public BigDecimal getProductProcessId() {
		return this.productProcessId;
	}
	
	public void setProductProcessId (String  productProcessId) {
		this.productProcessId = (productProcessId == null) || productProcessId.isEmpty() ? null : new BigDecimal(productProcessId);
	}
	
	public BigDecimal getProductTechnologyId() {
		return this.productTechnologyId;
	}
	
	public void setProductTechnologyId (String  productTechnologyId) {
		this.productTechnologyId = (productTechnologyId == null) || productTechnologyId.isEmpty() ? null : new BigDecimal(productTechnologyId);
	}
	
	public Integer getProductionSequence() {
		return this.productionSequence;
	}
	
	public void setProductionSequence(Integer productionSequence) {
		this.productionSequence = productionSequence;
	}
	
	public String getProcessName() {
		return this.processName;
	}
	
	public void setProcessName(String processName) {
		this.processName = processName;
	}
	
	public String getIsScheduleProcess() {
		return this.isScheduleProcess;
	}
	
	public void setIsScheduleProcess(String isScheduleProcess) {
		this.isScheduleProcess = isScheduleProcess;
	}
	
	public String getIsFinishedProcess() {
		return this.isFinishedProcess;
	}
	
	public void setIsFinishedProcess(String isFinishedProcess) {
		this.isFinishedProcess = isFinishedProcess;
	}
	
	public String getProcessRemark() {
		return this.processRemark;
	}
	
	public void setProcessRemark(String processRemark) {
		this.processRemark = processRemark;
	}
	
	public java.util.Date getFinishedTime() {
		return this.finishedTime;
	}
	
	public void setFinishedTime(java.util.Date finishedTime) {
		this.finishedTime = finishedTime;
	}
	
	public String getSigned() {
		return this.signed;
	}
	
	public void setSigned(String signed) {
		this.signed = signed;
	}
}
