package com.huigou.topsun.product.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.huigou.topsun.common.NumberToStringSerializer;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author YourUserName
 * 产品物料组成
 */
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
@Entity
@Table(name = "product_material")
public class ProductMaterial implements Serializable {

	/**
	 * 产品物料组成ID
	 */
	@Id
	@JsonSerialize(using = NumberToStringSerializer.class)
	@Column(name = "product_material_id", nullable = false)
	private BigDecimal productMaterialId;

	/**
	 * 产品ID
	 */
	@JsonSerialize(using = NumberToStringSerializer.class)
	@Column(name = "product_id", nullable = true)
	private BigDecimal productId;

	/**
	 * 物料ID
	 */
	@Column(name = "material_id", nullable = true, length = 32)
	private String materialId;

	/**
	 * 物料数量
	 */
	@Column(name = "material_number", nullable = true)
	private Integer materialNumber;

	/**
	 * BOM版本
	 */
	@Column(name = "bom_version", nullable = true, length = 128)
	private String bomVersion;

	/**
	 * 产品BOM类型(bom_type)
	 */
	@Column(name = "bom_type", nullable = true, length = 32)
	private String bomType;
	
	public BigDecimal getProductMaterialId() {
		return this.productMaterialId;
	}
	
	public void setProductMaterialId (String  productMaterialId) {
		this.productMaterialId = (productMaterialId == null) || productMaterialId.isEmpty() ? null : new BigDecimal(productMaterialId);
	}
	
	public BigDecimal getProductId() {
		return this.productId;
	}
	
	public void setProductId (String  productId) {
		this.productId = (productId == null) || productId.isEmpty() ? null : new BigDecimal(productId);
	}
	
	public String getMaterialId() {
		return this.materialId;
	}
	
	public void setMaterialId(String materialId) {
		this.materialId = materialId;
	}
	
	public Integer getMaterialNumber() {
		return this.materialNumber;
	}
	
	public void setMaterialNumber(Integer materialNumber) {
		this.materialNumber = materialNumber;
	}
	
	public String getBomVersion() {
		return this.bomVersion;
	}
	
	public void setBomVersion(String bomVersion) {
		this.bomVersion = bomVersion;
	}
	
	public String getBomType() {
		return this.bomType;
	}
	
	public void setBomType(String bomType) {
		this.bomType = bomType;
	}
}
