package com.huigou.topsun.product.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.huigou.topsun.common.NumberToStringSerializer;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author YourUserName
 * 产品版面颜色
 */
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
@Entity
@Table(name = "product_face_color")
public class ProductFaceColor implements Serializable {

	/**
	 * 产品颜色ID
	 */
	@Id
	@JsonSerialize(using = NumberToStringSerializer.class)
	@Column(name = "product_face_color_id", nullable = false)
	private BigDecimal productFaceColorId;

	/**
	 * 产品版面ID
	 */
	@Column(name = "product_face_id", nullable = true, length = 32)
	private BigDecimal productFaceId;

	/**
	 * 颜色ID
	 */
	@Column(name = "color_id", nullable = true, length = 32)
	private BigDecimal colorId;

	/**
	 * 覆盖率(单位%)
	 */
	@Column(name = "coverage_rate", nullable = true)
	private Double coverageRate;

	/**
	 * 排序序号
	 */
	@Column(name = "sort_order", nullable = true)
	private Integer sortOrder;
	
	public BigDecimal getProductFaceColorId() {
		return this.productFaceColorId;
	}
	
	public void setProductFaceColorId (String  productFaceColorId) {
		this.productFaceColorId = (productFaceColorId == null) || productFaceColorId.isEmpty() ? null : new BigDecimal(productFaceColorId);
	}
	
	public BigDecimal getProductFaceId() {
		return this.productFaceId;
	}
	
	public void setProductFaceId(String productFaceId) {
		this.productFaceId = (productFaceId == null) || productFaceId.isEmpty() ? null : new BigDecimal(productFaceId);
	}
	
	public BigDecimal getColorId() {
		return this.colorId;
	}
	
	public void setColorId(String colorId) {
		this.colorId = (colorId == null) || colorId.isEmpty() ? null : new BigDecimal(colorId);
	}
	
	public Double getCoverageRate() {
		return this.coverageRate;
	}
	
	public void setCoverageRate(Double coverageRate) {
		this.coverageRate = coverageRate;
	}
	
	public Integer getSortOrder() {
		return this.sortOrder;
	}
	
	public void setSortOrder(Integer sortOrder) {
		this.sortOrder = sortOrder;
	}
}
