package com.huigou.topsun.product.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.huigou.topsun.common.NumberToStringSerializer;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author YourUserName
 * 产品详细信息
 */
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
@Entity
@Table(name = "product_detail")
public class ProductDetail implements Serializable {

	/**
	 * 产品详细信息ID
	 */
	@Id
	@JsonSerialize(using = NumberToStringSerializer.class)
	@Column(name = "product_detail_id", nullable = false)
	private BigDecimal productDetailId;

	/**
	 * 产品ID
	 */
	@JsonSerialize(using = NumberToStringSerializer.class)
	@Column(name = "product_id", nullable = true)
	private BigDecimal productId;

	/**
	 * 工厂名称
	 */
	@Column(name = "factory_name", nullable = true, length = 255)
	private String factoryName;

	/**
	 * 版面(product_layout)
	 */
	@Column(name = "product_layout", nullable = true, length = 32)
	private String productLayout;

	/**
	 * 英文名
	 */
	@Column(name = "product_english_name", nullable = true, length = 255)
	private String productEnglishName;

	/**
	 * 产品简称
	 */
	@Column(name = "product_short_name", nullable = true, length = 128)
	private String productShortName;

	/**
	 * 产品背面ID
	 */
	@Column(name = "back_product_face_id", nullable = true)
	private BigDecimal backProductFaceId;

	/**
	 * 产品正面ID
	 */
	@Column(name = "right_product_face_id", nullable = true)
	private BigDecimal rightProductFaceId;

	/**
	 * 产品承印物
	 */
	@Column(name = "product_substrate", nullable = true, length = 255)
	private String productSubstrate;

	/**
	 * 材料代号
	 */
	@Column(name = "material_code", nullable = true, length = 255)
	private String materialCode;

	/**
	 * 产品代号
	 */
	@Column(name = "product_code", nullable = true, length = 255)
	private String productCode;

	/**
	 * 英文代号
	 */
	@Column(name = "product_en_code", nullable = true, length = 255)
	private String productEnCode;

	/**
	 * 型体配色
	 */
	@Column(name = "body_color", nullable = true, length = 255)
	private String bodyColor;

	/**
	 * 客户料号
	 */
	@Column(name = "customer_material_code", nullable = true, length = 255)
	private String customerMaterialCode;

	/**
	 * 版本号
	 */
	@Column(name = "version_no", nullable = true, length = 255)
	private String versionNo;

	/**
	 * 是否创建新规格书
	 */
	@Column(name = "is_new_specification", nullable = true, length = 1)
	private String isNewSpecification;

	/**
	 * 规格书编号
	 */
	@Column(name = "specification_no", nullable = true, length = 32)
	private String specificationNo;

	@Override
	public boolean equals(Object o) {
		if (this == o) return true;
		if (o == null || getClass() != o.getClass()) return false;
		ProductDetail that = (ProductDetail) o;
		return new EqualsBuilder().append(productDetailId, that.productDetailId).append(productId, that.productId).append(factoryName, that.factoryName).append(productLayout, that.productLayout).append(productEnglishName, that.productEnglishName).append(productShortName, that.productShortName).append(backProductFaceId, that.backProductFaceId).append(rightProductFaceId, that.rightProductFaceId).append(productSubstrate, that.productSubstrate).append(materialCode, that.materialCode).append(productCode, that.productCode).append(productEnCode, that.productEnCode).append(bodyColor, that.bodyColor).append(customerMaterialCode, that.customerMaterialCode).append(versionNo, that.versionNo).append(isNewSpecification, that.isNewSpecification).append(specificationNo, that.specificationNo).isEquals();
	}

	@Override
	public int hashCode() {
		return new HashCodeBuilder(17, 37).append(productDetailId).append(productId).append(factoryName).append(productLayout).append(productEnglishName).append(productShortName).append(backProductFaceId).append(rightProductFaceId).append(productSubstrate).append(materialCode).append(productCode).append(productEnCode).append(bodyColor).append(customerMaterialCode).append(versionNo).append(isNewSpecification).append(specificationNo).toHashCode();
	}

	public BigDecimal getProductDetailId() {
		return this.productDetailId;
	}
	
	public void setProductDetailId (String  productDetailId) {
		this.productDetailId = (productDetailId == null) || productDetailId.isEmpty() ? null : new BigDecimal(productDetailId);
	}
	
	public BigDecimal getProductId() {
		return this.productId;
	}
	
	public void setProductId (String  productId) {
		this.productId = (productId == null) || productId.isEmpty() ? null : new BigDecimal(productId);
	}
	
	public String getFactoryName() {
		return this.factoryName;
	}
	
	public void setFactoryName(String factoryName) {
		this.factoryName = factoryName;
	}
	
	public String getProductLayout() {
		return this.productLayout;
	}
	
	public void setProductLayout(String productLayout) {
		this.productLayout = productLayout;
	}
	
	public String getProductEnglishName() {
		return this.productEnglishName;
	}
	
	public void setProductEnglishName(String productEnglishName) {
		this.productEnglishName = productEnglishName;
	}
	
	public String getProductShortName() {
		return this.productShortName;
	}
	
	public void setProductShortName(String productShortName) {
		this.productShortName = productShortName;
	}
	
	public BigDecimal getBackProductFaceId() {
		return this.backProductFaceId;
	}
	
	public void setBackProductFaceId(String backProductFaceId) {
		this.backProductFaceId = (backProductFaceId == null) || backProductFaceId.isEmpty() ? null : new BigDecimal(backProductFaceId);
	}
	
	public BigDecimal getRightProductFaceId() {
		return this.rightProductFaceId;
	}
	
	public void setRightProductFaceId(String rightProductFaceId) {
		this.rightProductFaceId = (rightProductFaceId == null) || rightProductFaceId.isEmpty() ? null : new BigDecimal(rightProductFaceId);
	}
	
	public String getProductSubstrate() {
		return this.productSubstrate;
	}
	
	public void setProductSubstrate(String productSubstrate) {
		this.productSubstrate = productSubstrate;
	}
	
	public String getMaterialCode() {
		return this.materialCode;
	}
	
	public void setMaterialCode(String materialCode) {
		this.materialCode = materialCode;
	}
	
	public String getProductCode() {
		return this.productCode;
	}
	
	public void setProductCode(String productCode) {
		this.productCode = productCode;
	}
	
	public String getProductEnCode() {
		return this.productEnCode;
	}
	
	public void setProductEnCode(String productEnCode) {
		this.productEnCode = productEnCode;
	}
	
	public String getBodyColor() {
		return this.bodyColor;
	}
	
	public void setBodyColor(String bodyColor) {
		this.bodyColor = bodyColor;
	}
	
	public String getCustomerMaterialCode() {
		return this.customerMaterialCode;
	}
	
	public void setCustomerMaterialCode(String customerMaterialCode) {
		this.customerMaterialCode = customerMaterialCode;
	}
	
	public String getVersionNo() {
		return this.versionNo;
	}
	
	public void setVersionNo(String versionNo) {
		this.versionNo = versionNo;
	}
	
	public String getIsNewSpecification() {
		return this.isNewSpecification;
	}
	
	public void setIsNewSpecification(String isNewSpecification) {
		this.isNewSpecification = isNewSpecification;
	}
	
	public String getSpecificationNo() {
		return this.specificationNo;
	}
	
	public void setSpecificationNo(String specificationNo) {
		this.specificationNo = specificationNo;
	}
}
