package com.huigou.topsun.product.application.impl;

import com.huigou.cache.DictUtil;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.product.application.SizeGroupApplication;
import com.huigou.topsun.product.domain.SizeGroup;
import com.huigou.topsun.product.domain.SizeGroupItem;
import com.huigou.topsun.product.domain.query.SizeGroupQueryRequest;
import com.huigou.topsun.product.domain.vo.SizeGroupItemVo;
import com.huigou.topsun.product.domain.vo.SizeGroupVo;
import com.huigou.topsun.product.repository.SizeGroupItemRepository;
import com.huigou.topsun.product.repository.SizeGroupRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * title:
 * author:ZHT
 * date:2023/12/8
 * description:
 */
@Service
public class SizeGroupApplicationImpl extends BaseApplication implements SizeGroupApplication {

    @Autowired
    private SizeGroupRepository sizeGroupRepository;

    @Autowired
    private SizeGroupItemRepository sizeGroupItemRepository;

    @Override
    public Map<String, Object> getSizeGroupList(SizeGroupQueryRequest queryRequest) {

        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "sizeGroup");
        QueryModel model = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);

        model.putDictionary("sizeGroupType", DictUtil.getDictionary("sizeGroupType"));
        return this.sqlExecutorDao.executeSlicedQuery(model);
    }

    /**
     * 保存尺码组信息及尺码信息
     *
     * @param sizeGroupVo       尺码组信息
     * @param sizeGroupItemList 尺码列表
     * @return
     */
    @Override
    public SizeGroupVo saveSizeGroup(SizeGroupVo sizeGroupVo, List<SizeGroupItemVo> sizeGroupItemList) {
        // 获取尺码组对象
        SizeGroup sizeGroup = SizeGroupVo.getSizeGroup(sizeGroupVo);
        // 封装时间信息
//        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long timestamp = System.currentTimeMillis();
        sizeGroup.setCreatedDate(new Date(timestamp));

        sizeGroup = save(sizeGroupItemList, sizeGroup);
        sizeGroupVo.setSizeGroupId(sizeGroup.getSizeGroupId());

        return sizeGroupVo;
    }

    /**
     * 修改尺码组信息
     *
     * @param sizeGroupVo
     * @param sizeGroupItemList
     */
    @Override
    public void updateSizeGroup(SizeGroupVo sizeGroupVo, List<SizeGroupItemVo> sizeGroupItemList) {
        // 获取尺码组对象
        SizeGroup sizeGroup = SizeGroupVo.getSizeGroup(sizeGroupVo);
        // 封装时间信息
//        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long timestamp = System.currentTimeMillis();
        sizeGroup.setLastModifiedDate(new Date(timestamp));

        // 获取原有信息
        SizeGroup old = sizeGroupRepository.findOne(sizeGroup.getSizeGroupId());
        // 封装原有创建人信息到VO对象中
        sizeGroup.setCreatedById(old.getCreatedById());
        sizeGroup.setCreatedByName(old.getCreatedByName());
        sizeGroup.setCreatedDate(old.getCreatedDate());

        // 保存修改的信息
        save(sizeGroupItemList, sizeGroup);

    }

    /**
     * 根据sizeGroupId获取尺码组信息
     * @param sizeGroupId
     * @return
     */
    @Override
    public SizeGroupVo findSIzeGroupBySizeGroupId(String sizeGroupId) {
        SizeGroup sizeGroup = sizeGroupRepository.findOne(sizeGroupId);
        return SizeGroupVo.getSizeGroupVo(sizeGroup);
    }

    /**
     * 删除尺码组信息及相关尺码
     * @param ids
     */
    @Override
    public void deleteSizeGroup(List<String> ids) {
        ids.forEach(sizeGroupId->{
            List<SizeGroupItem> sizeGroupItemList = findBySizeGroupId(sizeGroupId);
            List<String> sizeGroupItemIds = sizeGroupItemList
                    .stream()
                    .map(SizeGroupItem::getSizeGroupItemId)
                    .collect(Collectors.toList());
            //删除尺码组相关的尺码信息
            deleteBySizeGroupItemIds(sizeGroupItemIds);
            //删除尺码组
            sizeGroupRepository.delete(sizeGroupId);
        });
    }

//    @Override
//    public Object slicedSizeGroupItemList(String sizeGroupId) {
//        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "slicedTechnologyProcessList");
//        String sql = queryDescriptor.getSql();
//        return this.sqlExecutorDao.queryToListMap(sql,sizeGroupId);
//        return findBySizeGroupId(sizeGroupId);
//    }

    /**
     * 提取方法--保存尺码组信息、尺码列表信息到数据库
     */
    private SizeGroup save(List<SizeGroupItemVo> sizeGroupItemList, SizeGroup sizeGroup) {
        // 保存
        sizeGroup = sizeGroupRepository.saveAndFlush(sizeGroup);
        // 保存尺码信息
        if (!sizeGroupItemList.isEmpty()) {
            // 尺码信息不为空,保存尺码列表
            String sizeGroupId = sizeGroup.getSizeGroupId();
            for (SizeGroupItemVo sizeGroupItemVo : sizeGroupItemList) {
                SizeGroupItem sizeGroupItem = SizeGroupItemVo.getSizeGroupItem(sizeGroupItemVo);
                sizeGroupItem.setSizeGroupId(sizeGroupId);
                sizeGroupItemRepository.saveAndFlush(sizeGroupItem);
            }
        }
        return sizeGroup;
    }

    /**
     * 删除尺码列表
     */
    public void deleteBySizeGroupItemIds(List<String> sizeGroupItemIds) {
        List<SizeGroupItem> sizeGroupItemList = sizeGroupItemRepository.findAll(sizeGroupItemIds);
        sizeGroupItemRepository.delete(sizeGroupItemList);
    }

    /**
     * 查找尺码组下的尺码列表
     */
    @Override
    public List<SizeGroupItem> findBySizeGroupId(String sizeGroupId) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "findBySizeGroupId");
        String sql = queryDescriptor.getSql();
        return this.sqlExecutorDao.queryToList(sql,SizeGroupItem.class,sizeGroupId);
        //        return sizeGroupItemRepository.findBySizeGroupId(sizeGroupId);
    }

    @Override
    public void deleteSizeGroupItemById(List<String> ids) {
        for (String id : ids) {
         sizeGroupItemRepository.delete(id);
        }
    }
}
