package com.huigou.topsun.product.application.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huigou.topsun.product.application.ProductProcessApplication;
import com.huigou.topsun.product.domain.ProductProcess;
import com.huigou.topsun.product.repository.ProductProcessRepository;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
@author qinzhenguan
*/
@Service
@RequiredArgsConstructor
public class ProductProcessApplicationImpl  implements ProductProcessApplication  {

	private final  ProductProcessRepository processRepository;
	private final ObjectMapper objectMapper;


	@Override
	public List<ProductProcess> queryProcessbyTechnologyId(BigDecimal technologyId) {
		ArrayList<ProductProcess> processList = new ArrayList<>();
		
		if(technologyId != null) {
			processList = (ArrayList<ProductProcess>) processRepository.findByProductTechnologyId(technologyId);
		}
		if(processList.size() == 0) {
			ProductProcess fc = new ProductProcess();
			fc.setProductTechnologyId("556");
			fc.setProductProcessId("111");
			fc.setProductionSequence(1);
			processList .add(fc);
		}
		return processList;
	}
}
