package com.huigou.topsun.customer.domain.vo;

import com.alibaba.fastjson.JSON;
import com.huigou.topsun.customer.domain.CustomerDebtContact;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import java.io.Serializable;
import java.util.Date;

/**
 * title:
 * author:ZHT
 * date:2023/12/19
 * description:
 */
@Data
public class CustomerDebtContactVo implements Serializable {
    /**
     * 催货款通知邮箱id
     */
    private String customerDebtContactId;

    /**
     * 客户id
     */
    private String customerId;

    /**
     * 邮箱地址
     */
    private String customerEmail;

    /**
     * 联系人
     */
    private String customerContact;

    /**
     * 是否开启邮件发送
     */
    private String sendEmail;

    /**
     * 前端展示字段
     */
    private String sendEmailTextView;

    /**
     * 邮箱类型（customerEmailType）-（宝绅邮箱、客户邮箱）
     */
    private String customerEmailType;

    /**
     * 创建人id
     */
    private String createdById;

    /**
     * 创建人名称
     */
    private String createdByName;

    /**
     * 创建日期
     */
    private Date createdDate;

    public static CustomerDebtContact getCustomerDebtContact(CustomerDebtContactVo customerDebtContactVo){
        return JSON.parseObject(JSON.toJSONString(customerDebtContactVo),CustomerDebtContact.class);
    }

    public static CustomerDebtContactVo getCustomerDebtContactVo(CustomerDebtContact customerDebtContact){
        return JSON.parseObject(JSON.toJSONString(customerDebtContact), CustomerDebtContactVo.class);
    }
}
