package com.huigou.topsun.customer.controller;

import com.huigou.topsun.customer.application.CustomerRelatedApplication;
import com.huigou.topsun.customer.domain.CustomerRelated;
import com.huigou.topsun.customer.domain.query.CustomerRelatedQueryRequest;
import com.huigou.topsun.customer.domain.vo.CustomerRelatedVo;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.List;

/**
 * title:
 * author:ZHT
 * date:2023/12/19
 * description:
 *    客户关联信息
 */
@Controller
@ControllerMapping("/customerRelated")
public class CustomerRelatedController extends CommonController {

    @Autowired
    private CustomerRelatedApplication customerRelatedApplication;

    @Override
    protected String getPagePath() {
        return "/biz/topsun/custcomer/";
    }
    /**
     * 跳转到客户管理信息展示页面
     */
    public String forwardCustomerRelatedList() {
        return forward("customerRelatedList");
    }
    /**
     * 跳转到客户管理信息新增页面
     */
    public String saveCustomerRelatedDetail() {
        return forward("customerRelatedDetail");
    }
    /**
     * 获取客户关联信息
     */
    public String slicedCustomerRelatedList() {
        SDO sdo = this.getSDO();
        String customerId = sdo.getString("customerId");
        List<CustomerRelated> customerRelatedList = customerRelatedApplication.getCustomerRelatedList(customerId);
        return packGridDataAndResult(customerRelatedList);
    }

    /**
     * 新增客户关联信息
     */
    public String saveCustomerRelated() {
        SDO sdo = this.getSDO();
        CustomerRelatedVo customerRelatedVo = sdo.toObject(CustomerRelatedVo.class);
        CustomerRelated customerRelated = CustomerRelatedVo.getCustomerRelated(customerRelatedVo);
        // 封装录入人信息
        String personMemberName = sdo.getOperator().getPersonMemberName();
        customerRelated.setCreatedByName(personMemberName);
        customerRelatedVo = customerRelatedApplication.saveCustomerRelated(customerRelated);
        return success(customerRelatedVo);
    }

    /**
     * 删除客户关联信息
     */
    public String deleteCustomerRelated() {
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        customerRelatedApplication.deleteCustomerRelated(ids);
        return success();
    }

}
