package com.huigou.topsun.base.coderule.domain.model;

import com.huigou.data.domain.model.AbstractEntity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;

/**
 * SSRF编号规则表
 * 
 * @author
 *         SSRF_CODE_RULE
 * @date 2018-06-20 15:20
 */
@Entity
@Table(name = "CODE_RULE")
public class CodeRule extends AbstractEntity {

    /**
     * code
     **/
    @Column(name = "code", length = 32)
    private String code;

    /**
     * name
     **/
    @Column(name = "name", length = 64)
    private String name;

    /**
     * org_id
     **/
    @Column(name = "org_id", length = 32)
    private String orgId;

    /**
     * rule_kind
     **/
    @Column(name = "rule_kind", length = 32)
    private String ruleKind;

    /**
     * current_value
     **/
    @Column(name = "current_value", length = 22)
    private Integer currentValue;

    /**
     * rule
     **/
    @Column(name = "rule", length = 128)
    private String rule;

    @Column(name = "last_modified_date", length = 22)
    private Date lastModifiedDate;

    @Column(name = "prefix", length = 32)
    private String prefix;

    @Transient
    private Integer lastValue;

    @Transient
    private String ruleView;

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String getRuleKind() {
        return this.ruleKind;
    }

    public void setRuleKind(String ruleKind) {
        this.ruleKind = ruleKind;
    }

    public Integer getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(Integer currentValue) {
        this.currentValue = currentValue;
    }

    public String getRule() {
        return this.rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public Date getLastModifiedDate() {
        return lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public String getPrefix() {
        return prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Integer getLastValue() {
        return lastValue;
    }

    public void setLastValue(Integer lastValue) {
        this.lastValue = lastValue;
    }

    public String getRuleView() {
        return ruleView;
    }

    public void setRuleView(String ruleView) {
        this.ruleView = ruleView;
    }

}
