var gridManager = null;

$(document).ready(function () {
    initializateUI();
    loadWorkInstructionListGrid();
});

function initializateUI() {
    UICtrl.layout("#layout", {leftWidth: 3});
}

function loadWorkInstructionListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        updateHandler: function(){
            updateHandler();
        },
        deleteHandler: deleteHandler
    });
    gridManager = UICtrl.grid("#workInstructionTableGrid", {
        columns: [
            {display: "指导书编号", name: "workInstructionBaseInfoId", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "产品名称", name: "productName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "产品类别", name: "productType", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "产品单位", name: "productUnit", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "尺码组id", name: "sizeGroupId", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "是否为唯一码产品", name: "isOnlyCodeTextView", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "是否不考虑形体配色", name: "isBodyColorTextView", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "是否禁用", name: "isDisableTextView", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "是否创建新规格书", name: "isNewSpecificationTextView", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "是否建立bom表", name: "isBuildBomTextView", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "确认日期", name: "confirmDate", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "确认人", name: "comfirmPerson", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "样品单号", name: "sampleOrderNo", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "库存名称", name: "stockName", width: 140, minWidth: 60, type: "string", align: "left"},
        ],
        dataAction: "server",
        url: web_app.name + '/workInstruction/slicedQueryWorkInstructionList.ajax',
        pageSize: 10,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            doView(data.workInstructionBaseInfoId);
        }
    });
    UICtrl.setSearchAreaToggle(gridManager);
}


function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}

function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}


function updateHandler() {

       let row = DataUtil.getUpdateRow(gridManager);

    UICtrl.addTabItem({
        tabid: 'updateWorkInstruction'+row.workInstructionBaseInfoId,
        text: "修改作业指导书",
        url: web_app.name + '/workInstruction/forwardDetailsWorkInstruction.do?id='+row.workInstructionBaseInfoId
    });
}


//删除按钮
function deleteHandler() {
    DataUtil.del({
        action: 'workInstruction/deleteWorkInstruction.ajax',
        gridManager: gridManager, idFieldName: 'workInstructionBaseInfoId',
        onSuccess: function () {
            reloadGrid();
        }
    });
}

function doView(workInstructionId) {
    UICtrl.addTabItem({
        tabid: 'workInstruction'+workInstructionId,
        text: "作业指导书详情",
        url: web_app.name + '/workInstruction/forwardDetailsWorkInstruction.job?id='+workInstructionId
    });
}