var sizeGroupGridManager = null;
$(document).ready(function () {
    initializateUI();
    loadSizeGroupListGrid();
    //bindQueryEvent();
    bindEvent();
});

function initializateUI() {
    UICtrl.layout("#layout", {leftWidth: 3});
}

// 加载页码表格
function loadSizeGroupListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        // 添加一行表格
        addHandler: function () {
            UICtrl.addGridRow(sizeGroupGridManager);
        },
        // 删除选中的尺码信息
        deleteHandler: function () {
            var _grid = UICtrl.getGridManager('#sizeGroupItemListGrid');
            DataUtil.delSelectedRows({
                action: 'sizeGroup/deleteSizeGroupItemById.ajax',
                param: {},
                gridManager: _grid,
                idFieldName: 'sizeGroupItemId',
                onSuccess: function () {
                    reloadGrid();
                }
            });
        }
    });

    // 表格
    sizeGroupGridManager = UICtrl.grid("#sizeGroupItemListGrid", {
        gridManager: null,
        columns: [
            {
                display: "尺码名称",
                name: "sizeGroupItemName",
                width: 100,
                minWidth: 60,
                type: "String",
                align: "left",
                editor: {
                    type: 'text',
                    required: true
                }
            },
            {
                display: "显示顺序",
                name: "sizeGroupItemSequence",
                width: 100,
                minWidth: 60,
                type: "String",
                align: "left",
                editor: {
                    type: 'text',
                    mask: 'nnn',
                    required: true
                }
            },
            {
                display: "备注",
                name: "sizeGroupItemRemark",
                width: 100,
                minWidth: 60,
                type: "String",
                align: "left",
                editor: {
                    type: 'text',
                    required: true
                }
            },
        ],
        dataAction: "server",
        url: web_app.name + '/sizeGroup/slicedSizeGroupItemList.ajax',
        parms: {sizeGroupId: getId},
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        enabledEdit: true,
        width: "98%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
    });
    UICtrl.setSearchAreaToggle(sizeGroupGridManager);
}


function bindQueryEvent() {
    $('#sizeGroupItemName').searchbox({
        type: "sizeGroupItem", name: "sizeGroupItemCode",
        onChange: function (value, data) {
            $('#sizeGroupItemId').val(data.sizeGroupItemId);
            $('#sizeGroupItemName').val(data.sizeGroupItemName);
        }
    });
}

// 定义点击事件
function bindEvent() {
    $("#save").click(function () {
        saveData("save");
    })
    $("#submit").click(function () {
        saveData("submit");
    })

    $("#close").click(function () {//关闭
        closeDispatchTabItem();
    })
}

function getSizeGroupItemDetail(sizeGroupAction) {
    //采购订单保存时数据不进行必填验证，提交时数据才进行必填验证
    var op = {};
    var check = true;
    var sizeGroupItemList = [];
    if (sizeGroupAction == "save") {
        check = false;
    }
    op = {check: check};
    var sizeGroup = $('#submitForm').formToJSON(op);
    if (!sizeGroup) {
        return false;
    }
    sizeGroupItemList = DataUtil.getGridData({
        gridManager: sizeGroupGridManager, isAllData: true, onCheck: check})
    if (!sizeGroupItemList) {
        return false;
    }
    sizeGroup.sizeGroupItemList = $.toJSON(sizeGroupItemList);
    return sizeGroup;
}

// 保存数据
function saveData(action) {
    var sizeGroupItemDetail = getSizeGroupItemDetail("submit");
    if (!sizeGroupItemDetail) {
        return;
    }
    Public.ajax(web_app.name + '/sizeGroup/saveSizeGroup.ajax?code=' + action,sizeGroupItemDetail,
        function (data) {
            setId(data.sizeGroupId);
            Public.successTip("数据保存成功");
            sizeGroupGridManager.setParm('sizeGroupId', data.sizeGroupId);
            sizeGroupGridManager.loadData();
        }
    );
}

// 关闭
function closeDispatchTabItem() {
    UICtrl.closeCurrentTab();
}


function setId(value) {
    $('#sizeGroupId').val(value);
}

function getId() {
    return $("#sizeGroupId").val();
}
/**
 * 刷新表格
 */
function reloadGrid(obj) {
    sizeGroupGridManager.loadData();
}
