var parametersGrid;
$(function () {
    initCallActivityParametersGrid();
});

function initCallActivityParametersGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function () {
            parametersGrid.appendRow({});
        },
        deleteHandler: function () {
            DataUtil.delSelectedRows({gridManager: parametersGrid});
        },
    });
    var paramters = parent.getCallActivityParameters($('#type').val());
    parametersGrid = UICtrl.grid("#parameters-grid", {
        columns: [
            {
                display: '源',
                name: 'source',
                width: 200,
                minWidth: 100,
                type: "string",
                align: "left",
                editor: {type: 'text'}
            },
            {
                display: '源表达式',
                name: 'sourceExpression',
                width: 200,
                minWidth: 100,
                type: "string",
                align: "left",
                editor: {type: 'text'}
            },
            {
                display: '目标',
                name: 'target',
                width: 200,
                minWidth: 100,
                type: "string",
                align: "left",
                editor: {type: 'text'}
            },
            {
                display: '目标表达式',
                name: 'targetExpression',
                width: 200,
                minWidth: 100,
                type: "string",
                align: "left",
                editor: {type: 'text'}
            },
        ],
        dataAction: 'local',
        data: {Rows: paramters},
        usePager: false,
        toolbar: toolbarOptions,
        width: '100%',
        height: '500',
        heightDiff: -13,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        enabledEdit: true
    });
}

function getCallActivityParameters() {
    var parameters = DataUtil.getGridData({
        gridManager: parametersGrid,
        isAllData: true
    });
    for (var i = 0; i < parameters.length; i++) {
        delete parameters[i].__id;
    }
    return parameters;
}