package com.huigou.topsun.syncOrg.controller;

import com.huigou.topsun.syncOrg.application.OrgSyncApplication;
import com.huigou.topsun.syncOrg.vo.EpOrgVo;
import com.huigou.topsun.syncOrg.vo.SapPersonVo.SapPersonVo;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.annotation.SkipAuth;
import com.huigou.uasp.bmp.opm.domain.model.org.Person;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/25/10:51
 * @Description: 获取同步的机构、部门、岗位、人员
 */
@Controller
@ControllerMapping("/syncOrg")
public class SyncOrgController extends CommonController {
    @Autowired
    private OrgSyncApplication orgSyncApplication;

    /**
     * 同步人员到EP
     * @return
     */
    @SkipAuth
    @RequestMapping( value = "/syncOrgInfo")
    @ResponseBody
    public EpOrgVo syncOrgInfo() {
        return orgSyncApplication.buildOrgVo();
    }

    @SkipAuth
    @RequestMapping( value = "/syncOrgToSap")
    @ResponseBody
    public void syncOrgToSap() throws IOException {
        orgSyncApplication.syncPersonListToSap();
    }

    public String insertOrUpdatePersonToSap(){
        SDO sdo = this.getSDO();
        String code = sdo.getString("code");
        String flag = sdo.getString("flag");
        List<String> codes = new ArrayList<>();
        codes.add(code);
        orgSyncApplication.syncPersonToSap(flag,codes);
        return success();
    }

    public String updatePersonToSap(){
        SDO sdo = this.getSDO();
        List<String> personIds = sdo.getStringList("personIds");
        List<String> codes = orgSyncApplication.getCodeById(personIds);
        orgSyncApplication.syncPersonToSap("U",codes);
        return success();
    }

    public String initAllPersonToSap(){
        SDO sdo = this.getSDO();
        orgSyncApplication.syncAllPersonToSap();
        return success();
    }

    public String enableOrDisablePerson(){
        SDO sdo = this.getSDO();
        String id = sdo.getId();
        String flag = sdo.getString("flag");
        List<SapPersonVo> sapPersonVos = orgSyncApplication.querySapPersonVoByFullId(id);
        orgSyncApplication.buildSapPerson(flag,sapPersonVos);
        return success();
    }
}
