package com.huigou.topsun.sap.wasteSale.controller;

import com.huigou.topsun.sap.wasteSale.application.WasteSaleItemApplication;
import com.huigou.topsun.sap.wasteSale.domain.query.WasteSaleQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/13/19:20
 * @Description:
 */
@Controller
@ControllerMapping("/wasteSaleItem")
public class WasteSaleItemController extends CommonController {
    @Resource
    private WasteSaleItemApplication wasteSaleItemApplication;

    public String queryWasteSaleItems(){
        SDO sdo = this.getSDO();
        WasteSaleQueryRequest queryRequest = sdo.toQueryRequest(WasteSaleQueryRequest.class);
        Map<String, Object> map = wasteSaleItemApplication.queryWasteSaleItems(queryRequest);
        return toResult(map);
    }

    public String deleteWasteSaleItem(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        wasteSaleItemApplication.deleteByIds(ids);
        return success();
    }
}
