package com.huigou.topsun.sap.wasteSale.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.sap.wasteSale.application.WasteSaleApplication;
import com.huigou.topsun.sap.wasteSale.domain.WasteSale;
import com.huigou.topsun.sap.wasteSale.domain.query.WasteSaleQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/13/19:20
 * @Description:
 */
@Controller
@ControllerMapping("/wasteSale")
public class WasteSaleController extends CommonController {
    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/wasteSale/";
    }

    @Resource
    private WasteSaleApplication wasteSaleApplication;

    public String forwardWasteSaleList(){
        return forward("wasteSaleList");
    }

    public String slicedWasteSaleList(){
        SDO sdo = this.getSDO();
        WasteSaleQueryRequest queryRequest = sdo.toQueryRequest(WasteSaleQueryRequest.class);
        Map<String, Object> map = wasteSaleApplication.slicedWasteSaleList(queryRequest);
        return toResult(map);
    }

    public String forwardWasteSaleDetail(){
        this.putAttribute("processDefinitionKey", WasteSaleApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        WasteSale wasteSale = new WasteSale();
        wasteSale.setStatusId(BizBillStatus.APPLYING.getId());
        /**
         * 设置jsp页面初始化填充数据，如果不设置， 那么在jsp页面上填写完表单之后立即提交申请TaskDescription获取不到时间和相关人员信息
         */
        Operator operator = getOperator();
        wasteSale.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        wasteSale.setBurks("1000");
        return forward("wasteSaleDetail",wasteSale);
    }

    public String showWasteSaleDetail(){
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        WasteSale wasteSale = wasteSaleApplication.findWasteSaleById(id);
        return forward("wasteSaleDetail",wasteSale);
    }
}
