package com.huigou.topsun.sap.transfers.application.impl;

import com.huigou.cache.DictUtil;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;

import com.huigou.topsun.sap.transfers.application.SapStockTransfersItemApplication;
import com.huigou.topsun.sap.transfers.domain.SapStockTransfersItem;
import com.huigou.topsun.sap.transfers.domain.query.SapStockTransfersQueryRequest;
import com.huigou.topsun.sap.transfers.repository.SapStockTransfersItemRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: LXH
 * @Date: 2024/03/26/10:16
 * @Description:
 */
@Service("sapStockTransfersApplicationItemApplication")
public class SapStockTransfersItemApplicationImpl extends BaseApplication implements SapStockTransfersItemApplication {
    @Autowired
    private SapStockTransfersItemRepository sapStockTransfersItemRepository;
    @Override
    public void saveSapStockTransfersItems(String sapStockTransfersId, List<SapStockTransfersItem> items) {
        for (SapStockTransfersItem item : items) {
            item.setEpstp("U");
            item.setTransfersId(sapStockTransfersId);
            sapStockTransfersItemRepository.save(item);
        }
    }

    @Override
    public Map<String, Object> querySapStockTransfersItems(SapStockTransfersQueryRequest queryRequest) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getTransfersId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "sapStockTransfersItems");

            QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            if (queryRequest.getTransfersId() != null) {
                queryModel.addCriteria(" and t.transfers_id =:sapStockTransfersId");
                queryModel.putParam("sapStockTransfersId", queryRequest.getTransfersId());
            }
            queryModel.putDictionary("meins", DictUtil.getDictionary("sapPermitUnit"));
            map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        }
        return map;
    }

    @Override
    public void deleteByIds(List<String> ids) {
        ids.forEach(id->{
            sapStockTransfersItemRepository.delete(id);
        });
    }

    @Override
    public List<SapStockTransfersItem> findByTransfersId(String sapStockTransfersId) {
        return sapStockTransfersItemRepository.findByTransfersId(sapStockTransfersId);
    }
}
