package com.huigou.topsun.sap.suppliers.domain;

import com.alibaba.fastjson.annotation.JSONField;
import com.topsunit.query.annotations.Dictionary;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 
 * @TableName sap_suppliers_pay
 */
@Table(name="sap_suppliers_pay")
@Data
@Entity
public class SuppliersPay implements Serializable {


    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )

    private String id;

    /**
     * 主表id
     */
    @Column(name = "s_id")
    @JSONField(name = "S_ID")
    private String sId;

    /**
     * 公司代码
     */
    @Column(name = "bukrs")
    @JSONField(name = "BUKRS")
    private String bukrs;

    /**
     * 总帐中的统驭科目
     */
    @Column(name = "akont")
    @JSONField(name = "AKONT")
    private String akont;


    /**
     * 根据分配号排序代码
     */
    @Column(name = "zuawa")
    @JSONField(name = "ZUAWA")
    private String zuawa;

    /**
     * 付款条件代码
     */
    @Column(name = "zterm")
    @JSONField(name = "ZTERM")
    private String zterm;

    /**
     * 考虑的付款方式清单
     */
    @Column(name = "zwels")
    @JSONField(name = "ZWELS")
    private String zwels;


    /**
     * 检查双重发票或信贷凭单的标志
     */
    @Column(name = "reprf")
    @JSONField(name = "REPRF")
    private String reprf;

    /**
     * 中心记帐冻结
     */
    @Column(name = "sperr")
    @JSONField(name = "SPERR")
    private String sperr;

    /**
     * 对公司代码过帐冻结
     */
    @Column(name = "sperr_b")
    @JSONField(name = "SPERR_B")
    private String sperrB;

    @Column(name = "sequence")
    private int sequence;

    private static final long serialVersionUID = 1L;
}