package com.huigou.topsun.sap.suppliers.domain;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 
 * @TableName sap_suppliers_buyer
 */
@Table(name="sap_suppliers_buyer")
@Data
@Entity
public class SuppliersBuyer implements Serializable {


    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )
    private String id;

    /**
     * 主表id
     */
    @Column(name = "s_id")
    @JSONField(name = "S_ID")
    private String sId;

    /**
     * 采购组织
     */
    @Column(name = "ekorg")
    @JSONField(name = "EKORG")
    private String ekorg;

    /**
     * 货币码
     */
    @Column(name = "waers")
    @JSONField(name = "WAERS")
    private String waers;

    /**
     * 付款条件代码
     */
    @Column(name = "pay_condition")
    @JSONField(name = "ZTERM")
    private String payCondition;

    /**
     * 国际贸易条款
     */
    @Column(name = "inco1")
    @JSONField(name = "INCO1")
    private String inco1;

    /**
     * 国际贸易条款位置 1
     */
    @Column(name = "inco2_l")
    @JSONField(name = "INCO2_L")
    private String inco2L;

    /**
     * 国际贸易条款位置 2
     */
    @Column(name = "inco3_l")
    @JSONField(name = "INCO3_L")
    private String inco3L;

    /**
     * 标识：基于收货的发票验证
     */
    @Column(name = "webre")
    @JSONField(name = "WEBRE")
    private String webre;

    /**
     * 计算方案组（供应商）
     */
    @Column(name = "kalsk")
    @JSONField(name = "KALSK")
    private String kalsk;


    /**
     * 供应商办公室的负责销售人员
     */
    @Column(name = "verkf")
    @JSONField(name = "VERKF")
    private String verkf;


    /**
     * 供应商电话号码
     */
    @Column(name = "telf1")
    @JSONField(name = "TELF1")
    private String telf1;

    /**
     * 基于服务的发票校验标识
     */
    @Column(name = "lebre")
    @JSONField(name = "LEBRE")
    private String lebre;

    /**
     * 边境运输方式（欧盟内部贸易统计）
     */
    @Column(name = "expvz")
    @JSONField(name = "EXPVZ")
    private String expvz;


    /**
     * 采购冻结在采购组织层
     */
    @Column(name = "sperm")
    @JSONField(name = "SPERM")
    private String sperm;

    @Column(name = "sequence")
    private int sequence;

    private static final long serialVersionUID = 1L;
}