package com.huigou.topsun.sap.suppliers.domain;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 
 * @TableName sap_suppliers_bank
 */
@Table(name="sap_suppliers_bank")
@Data
@Entity
public class SuppliersBank implements Serializable {


    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )
    private String id;

    /**
     * 主表id
     */
    @Column(name = "s_id")
    @JSONField(name = "S_ID")
    private String sId;

    /**
     * 银行所属国家/地区代码
     */
    @Column(name = "banks")
    @JSONField(name = "BANKS")
    private String banks;

    /**
     * 银行代码
     */
    @Column(name = "bankl")
    @JSONField(name = "BANKL")
    private String bankl;

    /**
     * 银行帐户号码
     */
    @Column(name = "bankn")
    @JSONField(name = "BANKN")
    private String bankn;

    /**
     * 账户持有人姓名
     */
    @Column(name = "koinh")
    @JSONField(name = "KOINH")
    private String koinh;

    /**
     * 银行控制代码
     */
    @Column(name = "bkont")
    @JSONField(name = "BKONT")
    private String bkont;

    /**
     * 对方开户行类型
     */
    @Column(name = "bvtyp")
    @JSONField(name = "BVTYP")
    private String bvtyp;

    /**
     * 财务机构名称
     */
    @Column(name = "banka")
    @JSONField(name = "BANKA")
    private String banka;

    /**
     * 分行
     */
    @Column(name = "brnch")
    @JSONField(name = "BRNCH")
    private String brnch;

    /**
     * 银行细目的参考明细
     */
    @Column(name = "bkref")
    @JSONField(name = "BKREF")
    private String bkref;

    @Column(name = "sequence")
    private int sequence;

    private static final long serialVersionUID = 1L;
}