package com.huigou.topsun.sap.sapApplication.application.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huigou.topsun.sap.common.HttpClient;
import com.huigou.topsun.sap.common.domain.SapResult;
import com.huigou.topsun.sap.sapApplication.application.SapOrderApplication;
import com.huigou.topsun.sap.sapApplication.domain.query.SapPurchaseOrderQuery;
import com.huigou.topsun.util.SAPUtils;
import com.huigou.util.JSONUtil;
import com.huigou.util.StringUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author xin.lu
 * @Description: 查询sap采购订单
 * @date 2025/7/3016:49
 */
@Service("sapOrderApplication")
public class SapOrderApplicationImpl implements SapOrderApplication {
    @Resource
    private HttpClient httpClient;


    @Override
    public List<Map<String, String>> sapPurchaseOrder(String werks,String lifnr) {
        List<Map<String,String>>  sapMaterialVoList = new ArrayList<>();
        //{
        //    "ZTYPE": "BRTWR",
        //    "data": {
        //        "WERKS": [
        //            {
        //                "SIGN": "I",
        //                "OPTION":"EQ",
        //                "LOW": "1000",
        //                "HIGH": ""
        //            }
        //        ],
        //        "LIFNR": [
        //            {
        //                "SIGN": "I",
        //                "OPTION":"EQ",
        //                "LOW": "0000100029",
        //                "HIGH": ""
        //            }
        //        ]
        //    }
        //}
        Map<String,Object> queryMap = new HashMap<>();
        Map<String,Object> param = new HashMap<>();
        queryMap.put("ZTYPE","BRTWR");
        if (StringUtil.isNotBlank(werks)){
            List<Map<String,Object>> werksList = new ArrayList<>();
            Map<String, Object> param1 = buildParam(werks);
            werksList.add(param1);
            param.put("WERKS",werksList);
        }
        if (StringUtil.isNotBlank(lifnr)){
            List<Map<String,Object>> lifnrList = new ArrayList<>();
            Map<String, Object> param2 = buildParam(lifnr);
            lifnrList.add(param2);
            param.put("LIFNR",lifnrList);
        }
        queryMap.put("data",param);
        try {
            String json = httpClient.execute(queryMap, "sch_table");
            ObjectMapper objectMapper = SAPUtils.objectMapper();
            sapMaterialVoList = objectMapper.readValue(json, new TypeReference<List<Map<String, String>>>() {});

        } catch (IOException e) {
            throw new RuntimeException("查询sap采购订单失败："+e.getMessage());
        }
        return sapMaterialVoList;
    }

    public Map<String,Object> buildParam(String value){
        Map<String,Object> param = new HashMap<>();
        param.put("SIGN","I");
        param.put("OPTION","EQ");
        param.put("LOW",value);
        param.put("HIGH","");
        return param;
    }
}
