package com.huigou.topsun.sap.sapApplication.application.impl;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huigou.topsun.sap.common.HttpClient;
import com.huigou.topsun.sap.common.domain.SapResult;
import com.huigou.topsun.sap.sapApplication.application.SapAreaApplication;
import com.huigou.topsun.util.SAPUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/20/10:47
 * @Description:
 */
@Service("sapAreaApplication")
public class SapAreaApplicationImpl implements SapAreaApplication {
    @Autowired
    private HttpClient httpClient;
    @Override
    public List<Map<String, String>> getAreas(String LAND1) throws IOException {
        Map<String,Object> param = new HashMap<>();
        param.put("LAND1",LAND1);
        String execute = null;
        List<Map<String,String>> mapList = new ArrayList<>();
        try {
            execute = httpClient.execute(param, "search/sch_bland");
            Map<String, String> map = JSONObject.parseObject(execute, Map.class);
            List<SapResult> sapResultList = JSONObject.parseArray(JSONUtil.toJsonStr(map.get("MSG")), SapResult.class);
            if ("S".equals(sapResultList.get(0).getTYPE())) {
                ObjectMapper objectMapper = SAPUtils.objectMapper();
                mapList = objectMapper.readValue(com.huigou.util.JSONUtil.toString(map.get("FDATA")), new TypeReference<List<Map<String, String>>>() {});

            }
        } catch (IOException e) {
            throw new RuntimeException("根据国家查询地区出错。");
        }
        return mapList;
    }
}
