package com.huigou.topsun.sap.salesOrder.domain;

import java.io.Serializable;
import javax.persistence.*;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

/**
 * 销售订单表
 * @TableName sap_sales_order_other_info
 */
@Table(name="sap_sales_order_other_info")
@Data
@Entity
public class SapSalesOrderOtherInfo implements Serializable {
    /**
     * 销售订单其他信息id
     */
    @Id
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid", strategy = "guid")
    @Column(name = "sales_order_other_info_id")
    private String salesOrderOtherInfoId;

    /**
     * 销售订单id
     */
    @Column(name = "sales_order_id")
    private String salesOrderId;

    /**
     * 销售订单明细id
     */
    @Column(name = "sales_order_item_id")
    private String salesOrderItemId;

    /**
     * 销售项次
     */
    @Column(name = "sales_order_item_number")
    private String salesOrderItemNumber;

    /**
     * 尺码
     */
    @Column(name = "sales_order_other_info_size")
    private String salesOrderOtherInfoSize;

    /**
     * 指令数
     */
    @Column(name = "sales_order_other_info_instruction_count")
    private String salesOrderOtherInfoInstructionCount;

    /**
     * loss数
     */
    @Column(name = "sales_order_other_info_loss_count")
    private String salesOrderOtherInfoLossCount;

    /**
     * 销售订单其他信息备注
     */
    @Column(name = "sales_order_other_info_remarks")
    private String salesOrderOtherInfoRemarks;

    /**
     * 生产工单号
     */
    @Column(name = "sales_order_other_info_manufacture_code")
    private String salesOrderOtherInfoManufactureCode;

    private static final long serialVersionUID = 1L;
}