package com.huigou.topsun.sap.salesOrder.domain;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

/**
 * 销售订单表
 *
 * @TableName sap_sales_order
 */
@Table(name = "sap_sales_order")
@Data
@Entity
public class SapSalesOrder implements Serializable {
    /**
     * 销售订单id
     */
    @Id
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid", strategy = "guid")
    @Column(name = "sales_order_id")
    private String salesOrderId;

    /**
     * 销售单号
     */
    @Column(name = "sales_order_code")
    private String salesOrderCode;

    /**
     * 订单类型
     */
    @Column(name = "sales_order_type")
    private String salesOrderType;

    /**
     * 客户
     */
    @Column(name = "sales_order_customer")
    private String salesOrderCustomer;

    /**
     * 客户单号
     */
    @Column(name = "sales_order_customer_code")
    private String salesOrderCustomerCode;

    /**
     * 下单日期
     */
    @Column(name = "sales_order_date")
    private Date salesOrderDate;

    /**
     * 交易币别
     */
    @Column(name = "sales_order_currency")
    private String salesOrderCurrency;

    /**
     * 交易倍数
     */
    @Column(name = "sales_order_multiple")
    private String salesOrderMultiple;

    /**
     * 款式
     */
    @Column(name = "sales_order_style")
    private String salesOrderStyle;

    /**
     * 申购/采购单号
     */
    @Column(name = "sales_order_procure_code")
    private String salesOrderProcureCode;

    /**
     * 跟单员
     */
    @Column(name = "sales_order_merchandiser")
    private String salesOrderMerchandiser;

    /**
     * 备注
     */
    @Column(name = "sales_order_remarks")
    private String salesOrderRemarks;

    /**
     * 创建时间
     */
    @Column(name = "sales_order_create_time")
    private Date salesOrderCreateTime;

    /**
     * 创建人
     */
    @Column(name = "sales_order_creator")
    private String salesOrderCreator;

    /**
     * 审批时间
     */
    @Column(name = "sales_order_approval_time")
    private Date salesOrderApprovalTime;

    /**
     * 审核人
     */
    @Column(name = "sales_order_reviewer")
    private String salesOrderReviewer;

    private static final long serialVersionUID = 1L;
}