package com.huigou.topsun.sap.purchaseApproval.domain.query;

import com.huigou.data.domain.query.QueryAbstractRequest;
import lombok.Data;

import java.util.Date;

/**
 * @Auther: xin.lu
 * @Date: 2024/01/09/19:13
 * @Description:
 */
@Data
public class SapPurchaseApprovalQueryRequest extends QueryAbstractRequest {

    private String billCode;

    /**
     * 采购申请号
     */
    private String banfn;

    /**
     * 采购申请类型（只传输四种：NB、ZNB1、ZNB2和ZSTR）
     */
    private String bsart;

    /**
     * 采购申请类型描述
     */
    private String batxt;

    protected Date fillinBeginDate;

    protected Date fillinEndDate;

    private String statusKind;

    /**
     * 工厂
     */
    private String werks;

    /**
     * 工厂名称
     */
    private String name1;

    /**
     * 库存地点
     */
    private String lgort;

    /**
     * 库存地点名称
     */
    private String lgobe;

    /**
     * 物料编号
     */
    private String matnr;

    /**
     * 短文本
     */
    private String txz01;

    /**
     * 要求交货日期
     */
    private Date lfdatBegin;
    private Date lfdatEnd;

    /**
     * 申请日期
     */
    private Date badatBegin;
    private Date badatEnd;

    /**
     * 申购人ID
     */
    private String afnamId;

    /**
     * 申购人
     */
    private String nameText;

    /**
     * 申购人部门
     */
    private String afnamDeptName;

    /**
     * 申购人部门ID
     */
    private String afnamDeptId;

    /**
     * 创建人
     */
    private String ernam;
}
