package com.huigou.topsun.sap.purchaseApproval.domain;

import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;

import com.huigou.data.domain.model.AbstractEntity;
import lombok.Data;

/**
 * 
 * @TableName sap_purchase_approval_item
 */
@Table(name="sap_purchase_approval_item")
@Entity
@Data
public class SapPurchaseApprovalItem  extends AbstractEntity {

    /**
     * SAP采购申请审批id
     */
    @Column(name = "sap_purchase_approval_id")
    private String sapPurchaseApprovalId;

    /**
     * 项目编号（已删除（EBAN-LOEKZ=X）者不传EP；已结清（EBAN-EBAKZ=X）者也不传（结清指已全部转为采购订单））
     */
    @Column(name = "BNFPO")
    private String bnfpo;

    /**
     * 项目类别
     */
    @Column(name = "PSTYP")
    private String pstyp;

    /**
     * 项目类别描述
     */
    @Column(name = "PTEXT")
    private String ptext;

    /**
     * 科目分配类别
     */
    @Column(name = "KNTTP")
    private String knttp;

    /**
     * 科目分配类别描述
     */
    @Column(name = "KNTTX")
    private String knttx;

    /**
     * 物料号 
     */
    @Column(name = "MATNR")
    private String matnr;

    /**
     * 物料描述
     */
    @Column(name = "TXZ01")
    private String txz01;

    /**
     * 物料组
     */
    @Column(name = "MATKL")
    private String matkl;

    /**
     * 物料组描述
     */
    @Column(name = "WGBEZ")
    private String wgbez;

    /**
     * 采购申请数量
     */
    @Column(name = "MENGE")
    private BigDecimal menge;

    /**
     * 采购申请计量单位
     */
    @Column(name = "MEINS")
    private String meins;

    /**
     * 单位描述
     */
    @Column(name = "MSEHL")
    private String msehl;

    /**
     * 要求交货日期
     */
    @Column(name = "LFDAT")
    private Date lfdat;

    /**
     * 工厂
     */
    @Column(name = "WERKS")
    private String werks;

    /**
     * 名称
     */
    @Column(name = "NAME1")
    private String name1;

    /**
     * 库存地点
     */
    @Column(name = "LGORT")
    private String lgort;

    /**
     * 库存地点的描述 
     */
    @Column(name = "LGOBE")
    private String lgobe;

    /**
     * 采购组
     */
    @Column(name = "EKGRP")
    private String ekgrp;

    /**
     * 采购组描述
     */
    @Column(name = "EKNAM")
    private String eknam;

    /**
     * 评估价格
     */
    @Column(name = "PREIS")
    private BigDecimal preis;

    /**
     * 价格单位
     */
    @Column(name = "PEINH")
    private String peinh;

    /**
     * 币种
     */
    @Column(name = "WAERS")
    private String waers;

    /**
     * 评估金额
     */
    @Column(name = "RLWRT")
    private BigDecimal rlwrt;

    /**
     * 0需求(请求)日期
     */
    @Column(name = "BADAT")
    private Date badat;

    /**
     * 负责创建对象的人员姓名
     */
    @Column(name = "ERNAM")
    private String ernam;

    /**
     * 完整的人员名称
     */
    @Column(name = "NAME_TEXT")
    private String nameText;

    /**
     * 库存转储供货工厂
     */
    @Column(name = "RESWK")
    private String reswk;

    /**
     * 采购组织
     */
    @Column(name = "EKORG")
    private String ekorg;

    /**
     * 公司代码
     */
    @Column(name = "BUKRS")
    private String bukrs;

    /**
     * 删除标识
     */
    @Column(name = "LOEKZ")
    private String loekz;

    private static final long serialVersionUID = 1L;
}