package com.huigou.topsun.sap.produceSupplierReview.domain;

import com.huigou.data.domain.model.AbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * @Auther: xin.lu
 * @Date: 2024/06/03/15:44
 * @Description: 新供应商评审表
 */
@Entity
@Data
@Table(name = "sap_new_supplier_review")
public class NewSupplierReview extends AbstractEntity {
    /**
     * 供方调查表id
     */
    @Column(name = "produce_supplier_review_id")
    private String produceSupplierReviewId;
    /**
     * 供应商名称
     */
    @Column(name = "name")
    private String name;

    /**
     * 产品名称及类别
     */
    @Column(name = "product_name_and_type")
    private String productNameAndType;

    /**
     * 公司地址
     */
    @Column(name = "address")
    private String address;

    /**
     * 评审日期
     */
    @Column(name = "review_date")
    private Date reviewDate;

    /**
     * 联系人
     */
    @Column(name = "business_contact")
    private String businessContact;

    /**
     * 联系电话
     */
    @Column(name = "tel")
    private String tel;

    /**
     * 传真号码
     */
    @Column(name = "fax")
    private String fax;

}
