package com.huigou.topsun.sap.processQuotedPrice.domain;

import com.huigou.data.domain.model.AbstractEntity;
import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/10/30/13:47
 * @Description: 工序报价明细
 */
@Data
@Entity
@Table(name = "sap_process_quoted_price_item")
public class ProcessQuotedPriceItem extends AbstractEntity {

    @Column(name = "process_quoted_price_id")
    private String processQuotedPriceId;

    /**
     * 项次
     */
    @Column(name = "item_no")
    private String itemNo;

    /**
     * 启用 1
     * 禁用 0
     */
    @Column(name = "status")
    private String status;

    /**
     * 外发工序
     */
    @Column(name = "out_process")
    private String outProcess;

    /**
     * 外发工序描述
     */
    @Column(name = "out_process_name")
    private String outProcessName;

    /**
     * 机台
     */
    @Column(name = "machine_tool")
    private String machineTool;

    /**
     * 印刷色素
     */
    @Column(name = "print_color")
    private String printColor;

    /**
     * 产品编码
     */
    @Column(name = "product_code")
    private String productCode;

    /**
     * 产品名称
     */
    @Column(name = "product_name")
    private String productName;

    /**
     * 单位
     */
    @Column(name = "unit_name")
    private String unitName;

    /**
     * 库存名称
     */
    @Column(name = "store_name")
    private String storeName;

    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;

    /**
     * 禁用人id
     */
    @Column(name = "disable_person_id")
    private String disablePersonId;

    /**
     * 禁用人
     */
    @Column(name = "disable_person_name")
    private String disablePersonName;

    /**
     * 禁用时间
     */
    @Column(name = "disable_date")
    private Date disableDate;

    /**
     * 禁用原因
     */
    @Column(name = "disable_reason")
    private String disableReason;

    @Transient
    private List<Map<String,Object>> numberList;

}
