package com.huigou.topsun.sap.processQuotedPrice.application;

import com.huigou.topsun.sap.processQuotedPrice.domain.ProcessQuotedPriceItem;
import com.huigou.topsun.sap.processQuotedPrice.domain.ProcessQuotedPriceItemNumber;
import com.huigou.topsun.sap.processQuotedPrice.domain.query.ProcessQuotedPriceQueryRequest;
import com.huigou.topsun.sap.processQuotedPrice.domain.vo.ProcessQuotedPriceAndMwskzVo;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/10/30/14:10
 * @Description:
 */
public interface ProcessQuotedPriceItemApplication {
    public static final String QUERY_XML_FILE_PATH = "config/topsun/sap/processQuotedPrice/processQuotedPrice.xml";
    void saveProcessQuotedPriceItems(String processQuotedPriceId, List<ProcessQuotedPriceItem> processQuotedPriceItems);

    Map<String,Object> queryProcessQuotedPriceItems(ProcessQuotedPriceQueryRequest queryRequest);

    void deleteByIds(List<String> ids);

    List<ProcessQuotedPriceItem> findByProcessQuotedPriceId(String processQuotedPriceId);

    void updateProcessQuotedPriceItemStatus(List<String> ids,String status);

    Map<String, Object> print(String id);

    /**
     * 根据产品编码和工序查询产品数量区间的含税单价
     * @param productCode
     * @param outProcess
     * @param number
     * @return
     */
    ProcessQuotedPriceAndMwskzVo findPriceByProductAndProcess(ProcessQuotedPriceAndMwskzVo data,String productCode, String outProcess, BigDecimal number, String lifnr);

    ProcessQuotedPriceItemNumber findQuotedPriceByProductAndProcess(String productCode, String outProcess, BigDecimal number, String lifnr);
}
